(defun c:2droof-final-islands-hatch (/ *error* _vl-sort exe 2droof-final 2droof3d 2droof3d-island hatchprocess make3dlw unique _ilpp rlw col unit mid cmde pea ape osm ent lst acDoc sol1 sol2l ss lws ang *d* regs islrgs isl sel mainreg main el ell vll vl tr)

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

  (defun *error* (m)
    (if ang (setq *ang* ang))
    (if cmde (setvar 'cmdecho cmde))
    (if pea (setvar 'peditaccept pea))
    (if ape (setvar 'aperture ape))
    (if osm (setvar 'osmode osm))
    (if m (prompt m))
    (princ)
  )

  (defun _vl-sort ( lst func )
    (mapcar
      (function (lambda ( x ) (nth x lst)))
      (vl-sort-i lst func)
    )
  )

  (defun exe ( lst )
    (if command-s
      (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) lst))
        (apply (function vl-cmdf) lst)
      )
      (apply (function vl-cmdf) lst)
    )
  )

  ;;;-----------------------------------------------------------------------------;;;
  ;;;  
  ;;;  ---------------------------------------------------------------------------;;;
  ;;;  SlopedRoof                                                                 ;;;
  ;;;  ---------------------------------------------------------------------------;;;
  ;;;  function : Find the ridge lines of sloped roof                             ;;;
  ;;;  ---------------------------------------------------------------------------;;;
  ;;;  Return:                                                                    ;;;
  ;;;         2D -- SlopedRoof Lines / SlopedRoof Closed Polygons of  Each Side   ;;;
  ;;;         3D -- SlopedRoof Closed Polygons of Each face                       ;;;
  ;;;                          / A Union Surface                                  ;;;
  ;;;                          / Solids of Each face                              ;;;
  ;;;  ---------------------------------------------------------------------------;;;
  ;;;  Writen By GSLS(SS) June 2014                                               ;;;
  ;;;        (C)  EasyCity OptDesign Studio of Building Structures                ;;;
  ;;;  Email: chlh_jd@126.com        Tel:86-0592-5391029    Fax:86-0592-5391020   ;;;
  ;;;  ---------------------------------------------------------------------------;;;
  ;;;  Main thread reference :                                                    ;;;
  ;;;      JianGuo Li, Algorithm about generate slopedroof line from 2D polygon.  ;;;
  ;;;      [BC Dissertation]Hubei University in China . 2009.                     ;;;
  ;;;      Many Thanks to JianGuo Li !                                            ;;;
  ;;;  -------------------------------------------                                ;;;
  ;;;  JianGuo Li's article main abort references :
  ;;;      [5] D.T.Lee. Medial axis transformation of a planar shape [J],IEEE Trans PAM I , 1982, 4:363-369
  ;;;      [6] Chin F, Snoeyink J., Wang C.A. Finding the medial axis of a simple polygon in linear time
  ;;;           [J]. Discrete and Computational Geometry , 1999, 21:405-420
  ;;;      [8] Joseph O,Rourke. Computational Geometry In C [M].Second Edition. Cambridge University Press, 2004.179-181
  ;;;      ......
  ;;;  ---------------------------------------------------------------------------;;;
  ;;;  Version revit See command Routine .                                        ;;;
  ;;;  -------------------------------------------                                ;;;
  ;;;  Thanks Ribar.M from http://www.theswamp.org  for do many test              ;;;
  ;;;  -------------------------------------------                                ;;;
  ;;;  Discuss website : http://www.theswamp.org/index.php?topic=41837.0          ;;;
  ;;;  -------------------------------------------                                ;;;
  ;;;  Any Advice will be welcome , Thank you !                                   ;;;
  ;;;  ---------------------------------------------------------------------------;;;
  (defun 2droof-final
    (/ unique dxf _vl-position-fuzz
       ang-equal ray-inters ray-int-line
       l_int_pl bisector bisector2
       lbisector format-i inzone?
       pipl? ss-pts2area round
       sign eqmember car-sort
       remove-nth assoc2 LM:Entity->Pointlist
       tcgroup eqgroup MR:ent->pts
       midpt errf foo1
       _closed2 _pedal suit-i
       used-si pnth add-item
       suit _closed _getclosed
       _getneibor _getsinglenoclosed
       _getclosedinfo _getclosedinfo-new _closeditself
       _get_minz _getnoclosedpair _getnoclosdedpairinfo
       foo start _svos
       _clos collinear-p mainprocess
       postprocess foo-n foo1-n _vl-sort ;_defined functions
       timee ll nnn
       nrgl nrglt loopn
       loopnt loopntt errn
       errnt errntt errm
       errmt errmtt pll
       ff fff la
       lll li pl        ;_local variables
       *error* _olderr  ;_error handle
       #gsls_systemvar# _2pi
       _pi2 *gsls_angfuzz* *gsls_disfuzz*  ;_global variables
    )

    (setq _2pi (* 2.0 pi)
          _pi2 (* 0.5 pi)
          *gsls_angfuzz* 1e-7
          *gsls_disfuzz* 1e-3
    )

    ;;----------------------- error handle
    (defun _svos ()
      (vla-startundomark
        (vla-get-activedocument (vlax-get-acad-object))
      )
      (setq #gsls_vlale# (mapcar (function getvar) #gsls_systemvar#)
            _olderr *error*
      )
      (defun *error* (msg)
        (_clos)
        (if msg (prompt msg))
        (princ)
      )
    )
    ;;-----------------------
    (defun _clos ()
      (if #gsls_vlale#
        (mapcar (function (lambda (x y)
                            (if y
                              (setvar x y)
                            )
                          )
                )
                #gsls_systemvar#
                #gsls_vlale#
        )
        (setq #gsls_vlale# nil)
      )
      (vla-endundomark
        (vla-get-activedocument (vlax-get-acad-object))
      )
      (setq *error* _olderr)
      (princ)
    )
    ;;-----------------------
    ;;
    (defun collinear-p (p1 p2 p3)
      (
        (lambda (a b c)
                (or
                  (equal (+ a b) c 1e-10)
                  (equal (+ b c) a 1e-10)
                  (equal (+ c a) b 1e-10)
                )
        )
        (distance p1 p2) (distance p2 p3) (distance p1 p3)
      )
    )
    ;;
    (defun _vl-sort ( lst func )
      (mapcar
        (function (lambda ( x ) (nth x lst)))
        (vl-sort-i lst func)
      )
    )
    ;;
    (defun unique (l)
      (if l (cons (car l) (unique (vl-remove (car l) l))))
    )         ; end (unique l)
    ;;
    (defun _pedal (p p1 p2)
      (inters p (polar p (+ _pi2 (angle p1 p2)) 1e3) p1 p2 nil)
    )         ; end (_pedal p p1 p2)
    ;;
    (defun suit-i (i k)
      (if (not i%)
        (setq i% 0)
      )
      (cond
        ((> i% n)
         (setq i% nil)
        )
        ((not (member i closed_il))
         (setq i% nil)
         i
        )
        (t
          (setq i% (1+ i%))
          (suit-i (format-i (k i) n) k)
        )
      )
    )         ; end (suit-i i k)
;|
    (defun used-si ( ti )
      (if	(and ti (setq ti (cons 11 ti)))
        (vl-remove nil
          (mapcar
            (function
              (lambda ( a )
                (if
                  (and
                    (or (member ti (car a)) (member ti (cadr a)))
                    (not (assoc 70 a))
                  )
                  (dxf 10 (car a))
                )
              )
            ) rgl
          )
        )
      )
    ); end (used-si ti)
|;
    ;;
    (defun pnth (a)
      (cond
        ((= (car a) 10)
         (nth (cdr a) pl)
        )
        ((nth (cdr a) tl))
      )
    )         ; end (pnth a)
    ;;
    (defun _get_minz (a / i1 i2 z1 z2 z)
      (setq i1 (dxf 11 (car a))
            i2 (dxf 11 (cadr a))
      )
      (cond
        ((and i1 i2)
              (setq z1 (nth i1 zl)
                    z2 (nth i2 zl)
                    z (min z1 z2)
              )
        )
        (i1
          (setq z (nth i1 zl))
        )
        (i2
          (setq z (nth i2 zl))
        )
      )
    )         ; end (_get_minz a)
    ;;
    (defun add-item (ti an chain / a b c d)
      (setq a (car chain)
            b (cadr chain)
            c (cons 11 ti)
            d (cons 12 an)
      )
      (cond
        ((member c chain)
          (while (not (equal (car chain) c))
            (setq chain (cdr chain))
          )
           (if an
             (cons (cons 12 an) chain)
             chain
           )  ;_More sides shared one vertex
        )
        ((and an (= (car a) 12))
         (cons (cons 12 an) (cons (cons 11 ti) (cdr chain)))
        )
        ((and (not an) (= (car a) 12))
         (cons (cons 11 ti) (cdr chain))
        )
        ((= (car a) 11)
          (cond
            ((= (cdr a) ti)
             (cons (cons 12 an) chain)
            )
            ((equal (nth ti tl) (nth (cdr a) tl))
             (cons (cons 12 an) chain)
            )
            (chain)
          )
        )
        (chain)
      )
    )         ; end (add-item ti an chain)
    ;;
    (defun suit0 (p sil / si s p1 p2 p3 p4 p5 pp d ssl ssl sdl)
      ;; this suit function just determine p in the offset-line , and sure the point P is the top one .
 (setq s (nth (car sil) sl)
       p1 (nth (car s) pl)
       p2 (nth (cadr s) pl)
       pp (_pedal p p1 p2)
       d (distance p pp)
 )
;|
      (setq ssl (vl-remove-if (function (lambda ( s ) (member (car s) sil))) sl))
      ;; if the point in the triangle {pa pb [i0~3]} which construct by the inzone side {pa pb}
      ;;                        and it's bisector rays inters with line {p p1} or line {p p2}
      ;; S.M. of Invalid ray-inters of side {p1 p2}
      ;;	         p2_________p1
      ;;          / \i1i0    / \
      ;; 	       /   \/\    /   \
      ;;        /    /\ \  /     \
      ;;       /    /  \ \/     /
      ;; 	     \bi_a    \/\bi_b/
      ;;        \ /      P \  /
      ;;         pa---------pb
      (setq ssl
        (mapcar
          (function
            (lambda ( s / pa pb pc pd an1 an2 i0 i1 i2 i3 i0c i1c i2d i3d iz iz1 l a p0 p01 )
              (setq pa  (nth (car s) pl)
                    pb  (nth (cadr s) pl)
                    an1 (dxf (car s) bl)
                    an2 (dxf (cadr s) bl)
                    pc (nth (car s) rel)
                    pd (nth (cadr s) rel)
                    i0c (inters p p1 pa pc nil)
                    i1c (inters p p2 pa pc nil)
                    i2d (inters p p1 pb pd nil)
                    i3d (inters p p2 pb pd nil)
                    l (list i0c i1c i2d i3d)
                    iz1 (> (pipl? p (list pa pb pd pc) *gsls_angfuzz*) 0)
              )
              (and
                iz1
                (vl-some (function (lambda ( x ) (and x (not (equal x p *gsls_disfuzz*))))) l)
              )
            )
          ) ssl
        )
      )
|;
      (if
        (and
          ;|(apply (function =) (cons nil ssl))|;
          ;_When there are continous intersections, it will delete effective vertex by mistake.
          (progn
            (setq p3 (nth (cadr sil) pl)
                  p4 (nth (cadr sil) rel)
                  p5 (inters p1 p p3 p4)
            )
            (or (not p5) (equal p5 p *gsls_disfuzz*))
          )
          (progn
            (setq p3 (nth (format-i (1+ (caddr sil)) n) pl)
                  p4 (nth (format-i (1+ (caddr sil)) n) rel)
                  p5 (inters p2 p p3 p4)
            )
            (or (not p5) (equal p5 p *gsls_disfuzz*))
          )
        )
        (progn
          (setq sdl
                (mapcar
                  (function
                    (lambda (s / p1 p2 an1 an2 pp)
                      (if
                        (and
                          (nth (car s) pl)
                          (nth (cadr s) pl)
                          (dxf (car s) bl)
                          (dxf (cadr s) bl)
                        )
                        (progn
                          (setq p1 (nth (car s) pl)
                                p2 (nth (cadr s) pl)
                                an1 (dxf (car s) bl)
                                an2 (dxf (cadr s) bl)
                                pp (_pedal p p1 p2)
                          )
                          (if
                            (or
                              (member (car s) sil)
                              (and pp (equal (distance p1 p2) (+ (distance p1 pp) (distance p2 pp)) *gsls_disfuzz*))
                              (and p p1 an1 p2 an2 (inzone? p p1 an1 p2 an2))
                            )
                            (distance p pp)
                            (min (distance p p1) (distance p p2))
                          )
                        )
                      )
                    )
                  )
                  sl
                )
          )
          (setq sdl (_vl-sort sdl (function <)))  ;_sort z value
          (setq sdl (vl-remove nil (list (car sdl) (cadr sdl) (caddr sdl))))  ;_if has not three value ,
          (if (not (vl-some (function (lambda (d1) (not (equal d d1 *gsls_disfuzz*)))) sdl))
            (/ (apply (function +) sdl) (length sdl))
          )
        )
      )          ;_return z
    )            ; end (suit0 p sil)
    ;;
    (defun suit (p sil / si s p1 p2 pp d sdl)
      ;; this suit function just determine p in the offset-line , not sure the point P is the top one .
 (setq s (nth (car sil) sl)
       p1 (nth (car s) pl)
       p2 (nth (cadr s) pl)
       pp (_pedal p p1 p2)
       d (distance p pp)
 )
      (setq sdl
            (mapcar
              (function
                (lambda (s / p1 p2 a pa pb an1 an2 pp)
                  (if
                    (and
                      (nth (car s) pl)
                      (nth (cadr s) pl)
                      (nth (car s) rgl)
                      (cadar (nth (car s) rgl))
                      (cadadr (nth (car s) rgl))
                    )
                    (progn
                      (setq p1 (nth (car s) pl)
                            p2 (nth (cadr s) pl)
                            a (nth (car s) rgl)
                            pa (pnth (cadar a))
                            pb (pnth (cadadr a))
                            an1 (cdaar a)
                            an2 (cdaadr a)
                            pp (_pedal p p1 p2)
                      )
                      (if
                        (or
                          (member (car s) sil)
                          (and pp (equal (distance p1 p2) (+ (distance p1 pp) (distance p2 pp)) *gsls_disfuzz*))
                          (and p pa an1 pb an2 (inzone? p pa an1 pb an2))
                          (and p pb an2 pa an1 (inzone? p pb an2 pa an1))
                        )
                        (distance p pp)
                        (min (distance p p1) (distance p p2))
                      )
                    )
                  )
                )
              )  ;_remove closed side
              (vl-remove-if (function (lambda (x) (member (car x) closed_il))) sl)
            )
      )
      (setq sdl (_vl-sort sdl (function <))
            sdl (vl-remove nil (list (car sdl) (cadr sdl) (caddr sdl)))
      )
      (if (not (vl-some (function (lambda (d1) (not (equal d d1 *gsls_disfuzz*)))) sdl))
        (/ (apply (function +) sdl) (length sdl))
      )          ;_return z
    )            ; end (suit p sil)
    ;;
    (defun suit1 (p sil / si s p1 p2 pp d i ssl sdl)
      ;; this suit function just determine p in the offset-line , not sure the point P is the top one .
 (setq s (nth (car sil) sl)
       p1 (nth (car s) pl)
       p2 (nth (cadr s) pl)
       pp (_pedal p p1 p2)
       d (distance p pp)
 )
      (setq sdl
            (mapcar
              (function
                (lambda (s / p1 p2 a pa pb an1 an2 pp)
                  (if
                    (and
                      (nth (car s) pl)
                      (nth (cadr s) pl)
                      (nth (car s) rgl)
                      (cadar (nth (car s) rgl))
                      (cadadr (nth (car s) rgl))
                    )
                    (progn
                      (setq p1 (nth (car s) pl)
                            p2 (nth (cadr s) pl)
                            a (nth (car s) rgl)
                            pa (pnth (cadar a))
                            pb (pnth (cadadr a))
                            an1 (cdaar a)
                            an2 (cdaadr a)
                            pp (_pedal p p1 p2)
                      )
                      (if
                        (or
                          (member (car s) sil)
                          (and pp (equal (distance p1 p2) (+ (distance p1 pp) (distance p2 pp)) *gsls_disfuzz*))
                          (and p pa an1 pb an2 (inzone? p pa an1 pb an2))
                        )  ;_here must use last fan-shaped zone of side
                        (distance p pp)
                        (min (distance p p1) (distance p p2))
                      )
                    )
                  )
                )
              )
              (mapcar (function (lambda (i) (nth i sl))) sil)
            )
      )
      (setq sdl (_vl-sort sdl (function <))
            sdl (vl-remove nil (list (car sdl) (cadr sdl) (caddr sdl)))
      )
      (if (not (vl-some (function (lambda (d1) (not (equal d d1 *gsls_disfuzz*)))) sdl))
        (/ (apply (function +) sdl) (length sdl))
      )  ;_return z
    )    ; end (suit1 p sil)
    ;; check closed
    (defun _closed ()  ;_(_closed) rgl
      (setq rgl
            (mapcar
              (function
                (lambda (r / a b c d e)
                        (setq a (car r)
                              b (cadr r)
                              c (caddr r)
                        )
                  (cond
                    (c r)
                    ((and (setq d (assoc 11 a)) (setq e (assoc 11 b)) (equal d e))
                          (setq closed_n (1+ closed_n)
                                closed_il (cons (dxf 10 a) closed_il)
                          )
                       (list (member d a) (member e b) (cons 70 1))
                    )
                    ((list a b))
                  )
                )
              )
              rgl
            )
      )
    )  ; end (_closed)
    ;;
    (defun _closed2 (/ il a a1 a2 an1 an2 p1 p2)
      (if (setq il (vl-remove-if (function (lambda (i) (vl-position i closed_il))) (mapcar (function car) bl)))
        (foreach i il
          (if
            (and
              (cadr (car (nth i rgl)))
              (cadr (cadr (nth i rgl)))
            )
            (progn
              (setq a (nth i rgl)
                    a1 (car a)
                    a2 (cadr a)
                    an1 (cdar a1)
                    an2 (cdar a2)
                    p1 (pnth (cadr a1))
                    p2 (pnth (cadr a2))
              )
              (if
                (and
                  (equal (angle p1 p2) an1 1e-3)
                  (equal (angle p2 p1) an2 1e-3)
                )
                (cond
                  ((= (caadr a1) 10)
                      (setq a1 (cons (cadr a2) (cdr a1))
                            a2 (cdr a2)
                            rgl (subst (list a1 a2 (cons 70 1)) a rgl)
                      )
                  )
                  (t
                    (setq a2 (cons (cadr a1) (cdr a2))
                          a1 (cdr a1)
                          rgl (subst (list a1 a2 (cons 70 1)) a rgl)
                    )
                  )
                )
              )
            )
          )
        )
      )
    )  ; end (_closed2)
    ;;; current used function 
    (defun _getclosed ()
      (if
        (setq rdl
              (vl-remove-if-not
                (function
                  (lambda (a / i)
                          (and
                            (assoc 70 a)
                            (setq i (dxf 10 (car a)))
                            ;_(not (assoc 70 (nth (format-i (1+ i) n) rgl)))
                            ;_(not (assoc 70 (nth (format-i (1- i) n) rgl)))
                            (not (member (format-i (1+ i) n) closed_il))
                            (not (member (format-i (1- i) n) closed_il))
                          )
                  )
                )
                rgl
              )
        )
        (setq rdl
              (mapcar
                (function
                  (lambda (a)
                          (list (_get_minz a) a)
                  )
                )
                rdl
              )
              rdl (_vl-sort rdl (function (lambda (a b) (< (car a) (car b)))))
        )
      )
    )  ; end (_getclosed)
    ;; Get closed info of side - old subfunction

    (defun _getclosedinfo (bi fi / ip0 ip1 ab cf bii fii p p0 p1 ip j0 j1 z)  ;_(_getclosedinfo 5 57)
      (defun f1 (/ ab p0 p01 abb pab anb)
        (and
          (setq z (suit ip0 (list bi (suit-i (format-i (1- bi) n) 1-) fi)))
          (or
            (not bii)
            (and
              (= bii (1- bi))  ;_neighbor is always inzone .
              (not  ;_neighbor no closed first .
                (and
                  (assoc 70 (nth (format-i (1- bii) n) rgl))
                  (setq ab (nth bii rgl))
                  (cadar ab)
                  (setq pab (pnth (cadar ab)))
                  (setq anb (cdaar ab))
                  (assoc 10 (cadr ab))
                  (setq p0 (ray-int-line pab anb (pnth (assoc 10 (cadr ab))) ip0))
                  (not (equal ip0 p0 *gsls_disfuzz*))
                  ;; ray can reached .
                  (setq abb (nth (suit-i (format-i (1- bii) n) 1-) rgl))
                  (cadar abb)
                  (or
                    (not (setq p01 (ray-inters pab anb (pnth (cadar abb)) (cdaar abb))))
                    (< (distance pab p0) (distance pab p01))
                  )
                )
              )
            )
              (if
                (and
                  ip0
                  (cadar (setq ab (nth bii rgl)))
                  (cdaar ab)
                  (cadadr ab)
                  (cdaadr ab)
                )
                (inzone? ip0 (pnth (cadar (setq ab (nth bii rgl)))) (cdaar ab) (pnth (cadadr ab)) (cdaadr ab))
              )
              ;; add reverse zone line , June 24 , 2014
              (if
                (and
                  ip0
                  (cadadr (setq ab (nth bii rgl)))
                  (cdaadr ab)
                  (cadar ab)
                  (cdaar ab)
                )
                (inzone? ip0 (pnth (cadadr (setq ab (nth bii rgl)))) (cdaadr ab) (pnth (cadar ab)) (cdaar ab))
              )
          )
        )
      )  ;; end (f1)
      (defun f2 (/ cf p1 p11 pcf anf cff)
        (and
          (setq z (suit ip1 (list fi (suit-i (format-i (1+ fi) n) 1+) bi)))
          (or
            (not fii)
            (and
              (= fii (1+ fi))  ;_neighbor is always inzone .
              (not  ;_neighbor no closed first .
                (and
                  (assoc 70 (nth (format-i (1+ fii) n) rgl))
                  (setq cf (nth fii rgl))
                  (cadadr cf)
                  (setq pcf (pnth (cadadr cf)))
                  (setq anf (cdaadr cf))
                  (assoc 10 (car cf))
                  (setq p1 (ray-int-line pcf anf (pnth (assoc 10 (car cf))) ip1))
                  (not (equal ip1 p1 *gsls_disfuzz*))
                  ;; ray can reached .
                  (setq cff (nth (suit-i (format-i (1+ fii) n) 1+) rgl))
                  (cadadr cff)
                  (or
                    (not (setq p11 (ray-inters pcf anf (pnth (cadadr cff)) (cdaadr cff))))
                    (< (distance pcf p1) (distance pcf p11))
                  )
                )
              )
            )
              (if
                (and
                  ip1
                  (cadar (setq cf (nth fii rgl)))
                  (cdaar cf)
                  (cadadr cf)
                  (cdaadr cf)
                )
                (inzone? ip1 (pnth (cadar (setq cf (nth fii rgl)))) (cdaar cf) (pnth (cadadr cf)) (cdaadr cf))
              )
              ;; add reverse zone line , June 24 , 2014
              (if
                (and
                  ip1
                  (cadadr (setq cf (nth fii rgl)))
                  (cdaadr cf)
                  (cadar cf)
                  (cdaar cf)
                )
                (inzone? ip1 (pnth (cadadr (setq cf (nth fii rgl)))) (cdaadr cf) (pnth (cadar cf)) (cdaar cf))
              )
          )
        )
      )  ;; end (f2)
      (if
        (and
          (/= bi fi)
          (setq a (nth bi rgl))  ;_??????,?????????????????,?????
          (setq c (nth fi rgl))
          (not (assoc 70 a))
          (not (assoc 70 c))
          (cadadr a)
          (cadar a)
          (cadar c)
          (cadadr c)
          (vl-remove nil
                     (list
                       (setq ip0 (ray-inters (pnth (cadadr a)) (cdaadr a) (pnth (cadar a)) (cdaar a)))
                       (setq ip1 (ray-inters (pnth (cadar c)) (cdaar c) (pnth (cadadr c)) (cdaadr c)))
                       (progn
                         (setq bii
                           (if
                             (not
                               (member (setq bii (suit-i (format-i (1- bi) n) 1-)) (list bi fi))
                             )
                             bii
                           )
                         )
                         (setq fii
                           (if
                             (not
                               (member (setq fii (suit-i (format-i (1+ fi) n) 1+)) (list bi fi))
                             )
                             fii
                           )
                         )
                         nil
                       )
                     )
          )
             (setq p (pnth (cadar c)))
             ;_(entmake (list (cons 0 "POINT") (cons 10 ip1) (cons 62 2)))
             (setq ip
               (cond
                 ((and ip0 ip1)
                   (cond
                     ((and (> (setq j0 (pipl? ip0 pl *gsls_angfuzz*)) 0) (> (setq j1 (pipl? ip1 pl *gsls_angfuzz*)) 0))
                       (cond
                         ((<= (distance p ip0) (distance p ip1))
                           (if (f1)
                             (list "back" ip0 z)
                           )
                         )
                         ((if (f2)
                            (list "for" ip1 z)
                          )
                         )
                       )
                     )
                     ((> (setq j0 (pipl? ip0 pl *gsls_angfuzz*)) 0)
                       (if (f1)
                         (list "back" ip0 z)
                       )
                     )
                     ((> (setq j1 (pipl? ip1 pl *gsls_angfuzz*)) 0)
                       (if (f2)
                         (list "for" ip1 z)
                       )
                     )
                   )
                 )
                 ((and ip0 (> (setq j0 (pipl? ip0 pl *gsls_angfuzz*)) 0))
                   (if (f1)
                     (list "back" ip0 z)
                   )
                 )
                 ((and ip1 (> (setq j1 (pipl? ip1 pl *gsls_angfuzz*)) 0))
                   (if (f2)
                     (list "for" ip1 z)
                   )
                 )
               )
             )
        )
        (append ip (list bi fi))
      )
    )  ; end (_getclosedinfo bi fi)

    ;; Get closed info of side - new subfunction
    (defun _getclosedinfo-new (bi fi / ip0 ip1 ab cf bii fii pa1 pa2 pc1 pc2 a c p0 p1 ip j0 j1 z z1 z2)  ;_(_getclosedinfo 5 57)
      (defun f1 (/ ab p0 p01 abb pab anb)
        (and
          (setq z (suit ip0 (list bi (suit-i (format-i (1- bi) n) 1-) fi)))
          (or
            (not bii)
            (and
              ;(= bii (1- bi)) ;_neighbor is always inzone . ;;; commented this line - mod. by M.R.
 (not    ;_neighbor no closed first .
   (and
     (assoc 70 (nth (format-i (1- bii) n) rgl))
     (setq ab (nth bii rgl))
     (cadar ab)
     (setq pab (pnth (cadar ab)))
     (setq anb (cdaar ab))
     (assoc 10 (cadr ab))
     (setq p0 (ray-int-line pab anb (pnth (assoc 10 (cadr ab))) ip0))
     (not (equal ip0 p0 *gsls_disfuzz*))
     ;; ray can reached .
     (setq abb (nth (suit-i (format-i (1- bii) n) 1-) rgl))
     (cadar abb)
     (or
       (not (setq p01 (ray-inters pab anb (pnth (cadar abb)) (cdaar abb))))
       (< (distance pab p0) (distance pab p01))
     )
   )
 )
            )
              (if
                (and
                  ip0
                  (cadar (setq ab (nth bii rgl)))
                  (cdaar ab)
                  (cadadr ab)
                  (cdaadr ab)
                )
                (inzone? ip0 (pnth (cadar (setq ab (nth bii rgl)))) (cdaar ab) (pnth (cadadr ab)) (cdaadr ab))
              )
              ;; add reverse zone line , June 24 , 2014
              (if
                (and
                  ip0
                  (cadadr (setq ab (nth bii rgl)))
                  (cdaadr ab)
                  (cadar ab)
                  (cdaar ab)
                )
                (inzone? ip0 (pnth (cadadr (setq ab (nth bii rgl)))) (cdaadr ab) (pnth (cadar ab)) (cdaar ab))
              )
          )
        )
      )  ;; end (f1)
      (defun f2 (/ cf p1 p11 pcf anf cff)
        (and
          (setq z (suit ip1 (list fi (suit-i (format-i (1+ fi) n) 1+) bi)))
          (or
            (not fii)
            (and
              ;(= fii (1+ fi)) ;_neighbor is always inzone . ;;; commented this line - mod. by M.R.
 (not    ;_neighbor no closed first .
   (and
     (assoc 70 (nth (format-i (1+ fii) n) rgl))
     (setq cf (nth fii rgl))
     (cadadr cf)
     (setq pcf (pnth (cadadr cf)))
     (setq anf (cdaadr cf))
     (assoc 10 (car cf))
     (setq p1 (ray-int-line pcf anf (pnth (assoc 10 (car cf))) ip1))
     (not (equal ip1 p1 *gsls_disfuzz*))
     ;; ray can reached .
     (setq cff (nth (suit-i (format-i (1+ fii) n) 1+) rgl))
     (cadadr cff)
     (or
       (not (setq p11 (ray-inters pcf anf (pnth (cadadr cff)) (cdaadr cff))))
       (< (distance pcf p1) (distance pcf p11))
     )
   )
 )
            )
              (if
                (and
                  ip1
                  (cadar (setq cf (nth fii rgl)))
                  (cdaar cf)
                  (cadadr cf)
                  (cdaadr cf)
                )
                (inzone? ip1 (pnth (cadar (setq cf (nth fii rgl)))) (cdaar cf) (pnth (cadadr cf)) (cdaadr cf))
              )
              ;; add reverse zone line , June 24 , 2014
              (if
                (and
                  ip1
                  (cadadr (setq cf (nth fii rgl)))
                  (cdaadr cf)
                  (cadar cf)
                  (cdaar cf)
                )
                (inzone? ip1 (pnth (cadadr (setq cf (nth fii rgl)))) (cdaadr cf) (pnth (cadar cf)) (cdaar cf))
              )
          )
        )
      )  ;; end (f2)
      (if
        (and
          (/= bi fi)
          (setq a (nth bi rgl))     ;_??????,?????????????????,?????
          (setq c (nth fi rgl))
          (not (assoc 70 a))
          (not (assoc 70 c))
          (cadadr a)
          (cadar a)
          (cadar c)
          (cadadr c)
          (progn
            (setq ip0 (ray-inters (pnth (cadadr a)) (cdaadr a) (pnth (cadar a)) (cdaar a)))
            (setq ip1 (ray-inters (pnth (cadar c)) (cdaar c) (pnth (cadadr c)) (cdaadr c)))
            (setq pc1 (pnth (cadar c)))
            (setq pc2 (pnth (cadadr c)))
            (setq pa1 (pnth (cadar a)))
            (setq pa2 (pnth (cadadr a)))
            (setq bii
              (if
                (not
                  (member (setq bii (suit-i (format-i (1- bi) n) 1-)) (list bi fi))
                )
                bii
              )
            )
            (setq fii
              (if
                (not
                  (member (setq fii (suit-i (format-i (1+ fi) n) 1+)) (list bi fi))
                )
                fii
              )
            )
            t
          )
             (setq ip
               (cond
                 ((and ip0 ip1)
                   (cond
                     ((and (> (setq j0 (pipl? ip0 pl *gsls_angfuzz*)) 0) (> (setq j1 (pipl? ip1 pl *gsls_angfuzz*)) 0))
                       (if (and pa1 pa2 pc1 pc2)
                         (cond
                           ((and (equal pa1 pc1 1e-6) (equal (distance pa1 ip1) (+ (distance pa1 ip0) (distance ip0 ip1)) 1e-6))
                             (if (f1)
                               (list "back" ip0 z)
                             )
                           )
                           ((and (equal pa1 pc2 1e-6) (equal (distance pa1 ip1) (+ (distance pa1 ip0) (distance ip0 ip1)) 1e-6))
                             (if (f1)
                               (list "back" ip0 z)
                             )
                           )
                           ((and (equal pa2 pc1 1e-6) (equal (distance pa2 ip1) (+ (distance pa2 ip0) (distance ip0 ip1)) 1e-6))
                             (if (f1)
                               (list "back" ip0 z)
                             )
                           )
                           ((and (equal pa2 pc2 1e-6) (equal (distance pa2 ip1) (+ (distance pa2 ip0) (distance ip0 ip1)) 1e-6))
                             (if (f1)
                               (list "back" ip0 z)
                             )
                           )
                           ((and (equal pc1 pa1 1e-6) (equal (distance pc1 ip0) (+ (distance pc1 ip1) (distance ip1 ip0)) 1e-6))
                             (if (f2)
                               (list "for" ip1 z)
                             )
                           )
                           ((and (equal pc1 pa2 1e-6) (equal (distance pc1 ip0) (+ (distance pc1 ip1) (distance ip1 ip0)) 1e-6))
                             (if (f2)
                               (list "for" ip1 z)
                             )
                           )
                           ((and (equal pc2 pa1 1e-6) (equal (distance pc2 ip0) (+ (distance pc2 ip1) (distance ip1 ip0)) 1e-6))
                             (if (f2)
                               (list "for" ip1 z)
                             )
                           )
                           ((and (equal pc2 pa2 1e-6) (equal (distance pc2 ip0) (+ (distance pc2 ip1) (distance ip1 ip0)) 1e-6))
                             (if (f2)
                               (list "for" ip1 z)
                             )
                           )
                           (t
                             (cond  ;;; previously was (<= (min (distance pa1 ip0) (distance pa2 ip0)) (min (distance pc1 ip1) (distance pc2 ip1)))
                               ((or (equal (distance pa1 ip1) (+ (distance pa1 ip0) (distance ip0 ip1)) 1e-6) (equal (distance pa2 ip1) (+ (distance pa2 ip0) (distance ip0 ip1)) 1e-6) (equal (distance pc1 ip1) (+ (distance pc1 ip0) (distance ip0 ip1)) 1e-6) (equal (distance pc2 ip1) (+ (distance pc2 ip0) (distance ip0 ip1)) 1e-6))
                                 (if (and (equal (distance pa1 ip0) (+ (distance pa1 pc1) (distance pc1 ip0)) 1e-6) (not (equal pa1 pc1 1e-6)))
                                   (setq ip0 pc1)
                                 )
                                  (if (and (equal (distance pa1 ip0) (+ (distance pa1 pc2) (distance pc2 ip0)) 1e-6) (not (equal pa1 pc2 1e-6)))
                                    (setq ip0 pc2)
                                  )
                                  (if (and (equal (distance pa2 ip0) (+ (distance pa2 pc1) (distance pc1 ip0)) 1e-6) (not (equal pa2 pc1 1e-6)))
                                    (setq ip0 pc1)
                                  )
                                  (if (and (equal (distance pa2 ip0) (+ (distance pa2 pc2) (distance pc2 ip0)) 1e-6) (not (equal pa2 pc2 1e-6)))
                                    (setq ip0 pc2)
                                  )
                                  (if (f1)
                                    (list "back" ip0 z)
                                  )
                               )
                               (t
                                 (if (and (equal (distance pc1 ip1) (+ (distance pc1 pa1) (distance pa1 ip1)) 1e-6) (not (equal pc1 pa1 1e-6)))
                                   (setq ip1 pa1)
                                 )
                                  (if (and (equal (distance pc1 ip1) (+ (distance pc1 pa2) (distance pa2 ip1)) 1e-6) (not (equal pc1 pa2 1e-6)))
                                    (setq ip1 pa2)
                                  )
                                  (if (and (equal (distance pc2 ip1) (+ (distance pc2 pa1) (distance pa1 ip1)) 1e-6) (not (equal pc2 pa1 1e-6)))
                                    (setq ip1 pa1)
                                  )
                                  (if (and (equal (distance pc2 ip1) (+ (distance pc2 pa2) (distance pa2 ip1)) 1e-6) (not (equal pc2 pa2 1e-6)))
                                    (setq ip1 pa2)
                                  )
                                  (if (f2)
                                    (list "for" ip1 z)
                                  )
                               )
                             )
                           )
                         )
                         (progn
                           (f1)
                           (setq z1 z)
                           (f2)
                           (setq z2 z)
                           (if (and z1 z2 (<= z1 z2))  ;;; previously was (and z1 z2 (> z1 z2))
                             (list "back" ip0 z1)
                             (if (and z1 z2)
                               (list "for" ip1 z2)
                               (cond
                                 (z1
                                   (list "back" ip0 z1)
                                 )
                                 (z2
                                   (list "for" ip1 z2)
                                 )
                               )
                             )
                           )
                         )
                       )
                     )
                     ((> (setq j0 (pipl? ip0 pl *gsls_angfuzz*)) 0)
                       (if (and pa1 pa2 pc1 pc2)
                         (progn
                           (if (and (equal (distance pa1 ip0) (+ (distance pa1 pc1) (distance pc1 ip0)) 1e-6) (not (equal pa1 pc1 1e-6)))
                             (setq ip0 pc1)
                           )
                           (if (and (equal (distance pa1 ip0) (+ (distance pa1 pc2) (distance pc2 ip0)) 1e-6) (not (equal pa1 pc2 1e-6)))
                             (setq ip0 pc2)
                           )
                           (if (and (equal (distance pa2 ip0) (+ (distance pa2 pc1) (distance pc1 ip0)) 1e-6) (not (equal pa2 pc1 1e-6)))
                             (setq ip0 pc1)
                           )
                           (if (and (equal (distance pa2 ip0) (+ (distance pa2 pc2) (distance pc2 ip0)) 1e-6) (not (equal pa2 pc2 1e-6)))
                             (setq ip0 pc2)
                           )
                         )
                       )
                        (if (f1)
                          (list "back" ip0 z)
                        )
                     )
                     ((> (setq j1 (pipl? ip1 pl *gsls_angfuzz*)) 0)
                       (if (and pc1 pc2 pa1 pa2)
                         (progn
                           (if (and (equal (distance pc1 ip1) (+ (distance pc1 pa1) (distance pa1 ip1)) 1e-6) (not (equal pc1 pa1 1e-6)))
                             (setq ip1 pa1)
                           )
                           (if (and (equal (distance pc1 ip1) (+ (distance pc1 pa2) (distance pa2 ip1)) 1e-6) (not (equal pc1 pa2 1e-6)))
                             (setq ip1 pa2)
                           )
                           (if (and (equal (distance pc2 ip1) (+ (distance pc2 pa1) (distance pa1 ip1)) 1e-6) (not (equal pc2 pa1 1e-6)))
                             (setq ip1 pa1)
                           )
                           (if (and (equal (distance pc2 ip1) (+ (distance pc2 pa2) (distance pa2 ip1)) 1e-6) (not (equal pc2 pa2 1e-6)))
                             (setq ip1 pa2)
                           )
                         )
                       )
                        (if (f2)
                          (list "for" ip1 z)
                        )
                     )
                   )
                 )
                 ((and ip0 (> (setq j0 (pipl? ip0 pl *gsls_angfuzz*)) 0))
                   (if (and pa1 pa2 pc1 pc2)
                     (progn
                       (if (and (equal (distance pa1 ip0) (+ (distance pa1 pc1) (distance pc1 ip0)) 1e-6) (not (equal pa1 pc1 1e-6)))
                         (setq ip0 pc1)
                       )
                       (if (and (equal (distance pa1 ip0) (+ (distance pa1 pc2) (distance pc2 ip0)) 1e-6) (not (equal pa1 pc2 1e-6)))
                         (setq ip0 pc2)
                       )
                       (if (and (equal (distance pa2 ip0) (+ (distance pa2 pc1) (distance pc1 ip0)) 1e-6) (not (equal pa2 pc1 1e-6)))
                         (setq ip0 pc1)
                       )
                       (if (and (equal (distance pa2 ip0) (+ (distance pa2 pc2) (distance pc2 ip0)) 1e-6) (not (equal pa2 pc2 1e-6)))
                         (setq ip0 pc2)
                       )
                     )
                   )
                    (if (f1)
                      (list "back" ip0 z)
                    )
                 )
                 ((and ip1 (> (setq j1 (pipl? ip1 pl *gsls_angfuzz*)) 0))
                   (if (and pc1 pc2 pa1 pa2)
                     (progn
                       (if (and (equal (distance pc1 ip1) (+ (distance pc1 pa1) (distance pa1 ip1)) 1e-6) (not (equal pc1 pa1 1e-6)))
                         (setq ip1 pa1)
                       )
                       (if (and (equal (distance pc1 ip1) (+ (distance pc1 pa2) (distance pa2 ip1)) 1e-6) (not (equal pc1 pa2 1e-6)))
                         (setq ip1 pa2)
                       )
                       (if (and (equal (distance pc2 ip1) (+ (distance pc2 pa1) (distance pa1 ip1)) 1e-6) (not (equal pc2 pa1 1e-6)))
                         (setq ip1 pa1)
                       )
                       (if (and (equal (distance pc2 ip1) (+ (distance pc2 pa2) (distance pa2 ip1)) 1e-6) (not (equal pc2 pa2 1e-6)))
                         (setq ip1 pa2)
                       )
                     )
                   )
                    (if (f2)
                      (list "for" ip1 z)
                    )
                 )
               )
             )
        )
        (append ip (list bi fi))
      )
    )  ; end (_getclosedinfo bi fi)
    ;; closed side can be closed  
    (defun _closeditself (ip / ty)
      ;; ip = ("for/back" ip1/ip0 z bi fi)
 (setq ty (car ip)
       p (cadr ip)
       z (caddr ip)
       bi (cadddr ip)
       fi (last ip)
       a (nth bi rgl)
       c (nth fi rgl)
 )
      (if (and (not (member bi closed_il)) (not (member fi closed_il)))
        (progn
          (if (not (setq i (_vl-position-fuzz p tl 1e-6)))
            (setq tl (append tl (list p))
                  zl (append zl (list (caddr ip)))
                  i (1- (length tl))
            )
          )
          (cond
            ((= ty "for")
                (setq c1 (list (add-item i nil (car c)) (add-item i nil (cadr c)) (cons 70 1))
                      rgl (subst c1 c rgl)
                      closed_n (1+ closed_n)
                      closed_il (cons (dxf 10 (car c)) closed_il)  ;_(vl-maxtimes closed_il)
                      fi (format-i (1+ fi) n)
                )
               (if (= (suit-i (format-i fi n) 1+) bi)
                 (setq a1 (list (add-item i nil (car a)) (add-item i nil (cadr a)) (cons 70 1))
                       rgl (subst a1 a rgl)
                       closed_n (1+ closed_n)
                       closed_il (cons (dxf 10 (car a)) closed_il)
                 )
                 (if
                   (and
                     (setq c (nth (suit-i (format-i fi n) 1+) rgl))
                     (assoc 10 (car c))
                     (assoc 10 (cadr c))
                     (assoc 10 (car a))
                     (assoc 10 (cadr a))
                   )
                   (setq p2 (pnth (assoc 10 (car c)))
                         p3 (pnth (assoc 10 (cadr c)))
                         p0 (pnth (assoc 10 (car a)))
                         p1 (pnth (assoc 10 (cadr a)))
                         an (bisector2 p0 p1 p2 p3)
                         rgl
                     (cond
                       ((assoc 70 a)
                        rgl
                       )
                       ((subst (list (car a) (add-item i an (cadr a))) a rgl))
                     )
                     rgl
                     (cond
                       ((assoc 70 c)
                        rgl
                       )
                       ((subst (list (add-item i an (car c)) (cadr c)) c rgl))
                     )
                   )
                 )
               )
            )
            ((= ty "back")
                (setq a1 (list (add-item i nil (car a)) (add-item i nil (cadr a)) (cons 70 1))
                      rgl (subst a1 a rgl)
                      closed_n (1+ closed_n)
                      closed_il (cons (dxf 10 (car a)) closed_il)
                      bi (format-i (1- bi) n)
                )
               (if (= (suit-i (format-i bi n) 1-) fi)
                 (setq c1 (list (add-item i nil (car c)) (add-item i nil (cadr c)) (cons 70 1))
                       rgl (subst c1 c rgl)
                       closed_n (1+ closed_n)
                       closed_il (cons (dxf 10 (car c)) closed_il)
                 )
                 (if
                   (and
                     (setq a (nth (suit-i (format-i bi n) 1-) rgl))
                     (assoc 10 (car c))
                     (assoc 10 (cadr c))
                     (assoc 10 (car a))
                     (assoc 10 (cadr a))
                   )
                   (setq p2 (pnth (assoc 10 (car c)))
                         p3 (pnth (assoc 10 (cadr c)))
                         p0 (pnth (assoc 10 (car a)))
                         p1 (pnth (assoc 10 (cadr a)))
                         an (bisector2 p0 p1 p2 p3)
                         rgl
                     (cond
                       ((assoc 70 a)
                        rgl
                       )
                       ((subst (list (car a) (add-item i an (cadr a))) a rgl))
                     )
                     rgl
                     (cond
                       ((assoc 70 c)
                        rgl
                       )
                       ((subst (list (add-item i an (car c)) (cadr c)) c rgl))
                     )
                   )
                 )
               )
            )
          )
          (_closed)
        )
      )
      (setq bi (suit-i (format-i bi n) 1-)
            fi (suit-i (format-i fi n) 1+)
      )
    )    ; end (_closeditself ip)
    ;; get closed side neighbor 
    (defun _getneighbor ()
      (setq rnl
            (unique
              (vl-remove
                nil
                (mapcar
                  (function
                    (lambda (r / sti bi fi)
                            (setq sti (dxf 10 (caadr r)))
                            (setq fi (suit-i (format-i (1+ sti) n) 1+)
                                  bi (suit-i (format-i (1- sti) n) 1-)
                            )
                      (cond
                        ((_getclosedinfo-new bi fi)) ((_getclosedinfo bi fi))
                      )
                    )
                  )
                  rdl
                )
              )
            )
            rnl (_vl-sort rnl (function (lambda (a b) (< (caddr a) (caddr b)))))
      )
    )    ; end (_getneighbor)
    ;; get single no closed
    (defun _getsinglenoclosed (/ il)
      (setq il (mapcar (function car) bl))
      (foreach i closed_il
        (setq il (vl-remove i il))
      )

      ;;; deal just one side like chlh_jd noticed... Mod. by M.R.
;|
      (vl-remove-if-not
        (function
          (lambda ( i )
            (and
              (member (format-i (1- i) n) closed_il)
              (member (format-i (1+ i) n) closed_il)
            )
          )
        ) il
      )
|;

      (vl-remove-if-not
        (function
          (lambda (i)
            (member (format-i (1+ i) n) closed_il)
          )
        )
        il
      )

    )    ; end (_getsinglenoclosed)
    ;; get no closed side neighbor
    (defun _getnoclosedpair (/ il)
      (if (setq il (vl-remove-if (function (lambda (i) (vl-position i closed_il))) (mapcar (function car) bl)))
        (setq
          il
          (vl-remove-if-not
            (function
              (lambda (i)
                      (not (member (format-i (1+ i) n) il))
              )
            )
            il
          )
              il
              (mapcar
                (function
                  (lambda (i)
                          (list i (suit-i (1+ i) 1+))
                  )
                )
                il
              )
              il (_vl-sort il
                          (function
                            (lambda (a b)
                                    (<
                                      (apply (function min) (vl-remove nil (mapcar (function (lambda (i) (_get_minz (nth i rgl)))) a)))
                                      (apply (function min) (vl-remove nil (mapcar (function (lambda (i) (_get_minz (nth i rgl)))) b)))
                                    )
                            )
                          )
                 )
        )
      )
    )    ; end (_getnoclosedpair)
    ;;
    (defun _getnoclosdedpairinfo ()
      (setq
        rnl
        (vl-remove nil
                   (mapcar
                     (function
                       (lambda (a)
                               (apply (function _getclosedinfo-new) a)
                       )
                     )
                     (_getnoclosedpair)
                   )
        )
        rnl (_vl-sort rnl (function (lambda (a b) (< (caddr a) (caddr b)))))
      )
      (if (not rnl)
        (setq
          rnl
          (vl-remove nil
                     (mapcar
                       (function
                         (lambda (a)
                                 (apply (function _getclosedinfo) a)
                         )
                       )
                       (_getnoclosedpair)
                     )
          )
          rnl (_vl-sort rnl (function (lambda (a b) (< (caddr a) (caddr b)))))
        )
      )
      rnl
    )    ; end (_getnoclosdedpairinfo)
    ;;;--------------------------------------------------------------------
    (defun foo-n ()
      (_getclosed)
      (_getneighbor)
      (while rnl
        (while rnl
          (_closeditself (car rnl))
          (if (setq ip
                (cond
                  ((_getclosedinfo-new bi fi)) ((_getclosedinfo bi fi))
                )
              )
            (_closeditself ip)
          )
          (setq rnl (cdr rnl))
        )
        (_getclosed)
        (_getneighbor)
      )
    )    ; end (foo-n)
    ;;;--------------------------------------------------------------------
    (defun foo1-n ()
      (_getnoclosdedpairinfo)
      (while rnl
        (while rnl
          (_closeditself (car rnl))
          (if (setq ip
                (cond
                  ((_getclosedinfo-new bi fi)) ((_getclosedinfo bi fi))
                )
              )
            (_closeditself ip)
          )
          (setq rnl (cdr rnl))
        )
        (_getnoclosdedpairinfo)
      )
    )    ; end (foo1-n)
    ;;;--------------------------------------------------------------------
    (defun foo ()
      (_getclosed)
      (_getneighbor)
      (while rnl
        (foreach ip rnl
          (_closeditself ip)
          (while (setq ip
                   (cond
                     ((_getclosedinfo-new bi fi)) ((_getclosedinfo bi fi))
                   )
                 )
            (_closeditself ip)
          )
        )
        (_getclosed)
        (_getneighbor)
      )
    )    ; end (foo)
    ;;;--------------------------------------------------------------------
    (defun foo1 ()
      (_getnoclosdedpairinfo)
      (while rnl
        (foreach ip rnl
          (_closeditself ip)
          (while (setq ip
                   (cond
                     ((_getclosedinfo-new bi fi)) ((_getclosedinfo bi fi))
                   )
                 )
            (_closeditself ip)
          )
        )
        (_getnoclosdedpairinfo)
      )
    )    ; end (foo1)
    ;;;--------------------------------------------------------------------
    ;;
    (defun dxf (a l)
      (cdr (assoc a l))
    )    ; end (dxf a l)
    ;; (_vl-position-fuzz 3.29 '(1.1 2.2 3.3 4.4 5.5 6.6 7.7 8.8 9.9) 0.01) => 2 ;;
    (defun _vl-position-fuzz (e l fuzz / n)
      (vl-some (function (lambda (x) (setq n (if (null n) 0 (1+ n))) (if (equal x e fuzz) n))) l)
    )    ; end (_vl-position-fuzz e l fuzz)
    ;;
    (defun car-sort (lst cmp / rtn)
      (setq rtn (car lst))
      (foreach itm (cdr lst)
        (if (apply cmp (list itm rtn))
          (setq rtn itm)
        )
      )
      rtn
    )
    ;;
    (defun ang-equal (a b fuzz)
      (equal
        (cond
          ((equal a _2pi fuzz)
           0.0
          )
          (a)
        )
        (cond
          ((equal b _2pi fuzz)
           0.0
          )
          (b)
        )
             fuzz
      )
    )    ; end (ang-equal a b fuzz)
    ;;
    (defun ray-inters (p0 an0 p1 an1 / p)
      ;; intersection of two ray line 
      ;; an0 an1 -- [0 2pi)
      ;; add deal angles  2pi equal 0
      ;; by GSLS(SS) May , 2014 
      (cond
        ((ang-equal (angle p0 p1) an0 *gsls_angfuzz*)
         p1
        )
        ((ang-equal (angle p1 p0) an1 *gsls_angfuzz*)
         p0
        )
        ((and
           (setq p (inters p0 (polar p0 an0 1000.0) p1 (polar p1 an1 1000.0) nil))
           (ang-equal (angle p0 p) an0 *gsls_angfuzz*)
           (ang-equal (angle p1 p) an1 *gsls_angfuzz*)
         )
         p
        )
      )
    )    ; end (ray-inters p0 an0 p1 an1)
    ;;
    (defun l_int_pl (p1 p2 l / p res)
      (mapcar (function (lambda (p3 p4)
                          (if (setq p (inters p1 p2 p3 p4 T))
                            (setq res (cons p res))
                          )
                        )
              )
              l
              (cdr l)
      )
      res
    )    ; end (l_int_pl p1 p2 l)
    ;;
    (defun ray-int-line (p0 an0 p1 p2 / p)
      ;; intersection of two ray line
      ;; an0 an1 -- [0 2pi)
      ;; add deal angles  2pi equal 0
      ;; by GSLS(SS) May , 2014 
      (cond
        ((ang-equal (angle p0 p1) an0 *gsls_angfuzz*)
         p1
        )
        ((ang-equal (angle p0 p2) an0 *gsls_angfuzz*)
         p2
        )
        ((and
           (setq p (inters p0 (polar p0 an0 1000.0) p1 p2 nil))
           (ang-equal (angle p0 p) an0 *gsls_angfuzz*)
           (equal (distance p1 p2) (+ (distance p p1) (distance p p2)) *gsls_disfuzz*)
         )
         p
        )
      )
    )    ; end (ray-int-line p0 an0 p1 p2)
    ;;
    (defun bisector (p0 p1 p2 / d a a0)
      ;; Get inter bisector of counterclockwise point set
      ;; p0 p1 p2 -- 3p of ccw polygon
      ;; return inter-bisector in [0 2pi)
      ;; by GSLS(SS) May , 2014 
 (setq d (distance p0 p1)
       a (- (setq a0 (angle p1 p0)) (angle p1 p2))
       a (- a0 (/ (angle '(0 0) (list (* d (cos a)) (* d (sin a)))) 2.0))
 )
      (cond
        ((< a 0)
         (+ a _2pi)
        )
        ((>= a _2pi)
         (- a _2pi)
        )
        (a)
      )
    )    ; end (bisector p0 p1 p2)
    ;;
    (defun bisector2 (p0 p1 p2 p3)
      ;; Get inter bisector between line (p1 p0) with line (p2 p3) 
      ;; p0 p1 p2 p4 -- 4p of ccw polygon
      ;; return inter-bisector in [0 2pi)
      ;; by GSLS(SS) May , 2014 
      (setq p0 (mapcar (function +) (mapcar (function -) p2 p1) p0))
      (if
        (<= (car (trans (mapcar (function -) p0 p3)
                        0
                        (mapcar (function -) p2 p3)
                 )
            )
            0
        )
        (bisector p0 p2 p3)
        (bisector p3 p2 p0)
      )
    )    ; end (bisector2 p0 p1 p2 p3)
    ;;-----------------------------------------------------
    (defun lbisector (l / i)
      (setq i -1)
      (mapcar (function (lambda (p0 p1 p2)
                                (setq i (1+ i))
                                (cons i (bisector p0 p1 p2))
                        )
              )
              (cons (last l) l)
              l
              (append (cdr l) (list (car l)))
      )
    )    ; end (lbisector l)
    ;;
    (defun format-i (i n)
      (cond
        ((< i 0)
         (+ i n)
        )
        ((>= i n)
         (- i n)
        )
        (i)
      )
    )    ; end (format-i i n)
    ;;;------------------------------------------------------------------------------;;;
    ;;; determine p in the zone build with a line {p0 p1} and two rays -- ray0 {p0 an0} ,
    ;;;    ray1 {p1 an1},  the zone is clockwise scan from ray0 to ray1 .
    ;;; Legend :
    ;;;  an0\+++++++++++/an1   
    ;;;      \++++p++++/       
    ;;;       \+++++++/        
    ;;;        p0---p1
    ;;; args :
    ;;;      p  -- a given point to determine whether in zone
    ;;;      p0 -- line's start point , also should be the ray0's source point .
    ;;;      an0 -- angle of the ray0
    ;;;      p1 -- line's end point , also should be the ray1's source point .
    ;;;      an1 -- angle of the ray1 
    (defun inzone? (p p0 an0 p1 an1 / fa a an2 an3 d)
      (defun fa (a)
        (cond
          ((< a 0)
           (+ a _2pi)
          )
          (a)
        )
      )  ; end (fa a)
      (setq a (angle p0 p1)
            an0 (fa (- an0 a))
            an1 (fa (- an1 a))
            an2 (fa (- (angle p0 p) a))
            an3 (fa (- (angle p1 p) a))
            d (car (trans (mapcar (function -) p p1)
                          0
                          (mapcar (function -) p0 p1)
                   )
              )
      )
      (and (<= an2 (+ an0 *gsls_angfuzz*))
           (>= an3 (- an1 *gsls_angfuzz*))
           (< d 0)
      )
    )    ; end (inzone? p p0 an0 p1 an1)
    ;;;
    ;;;Function : judge a point location with polygon
    ;;;Arg : pt -- a point
    ;;;      pts -- points of polygon
    ;;;      fuzz -- allowance
    ;;;return :
    ;;;     -1 -- out of polygon , 0 -- at , 1 -- in
    (defun pipl? (pt pts fuzz / is at a)
      ;; by Jueao Sword  
      ;; Edit by GSLS(SS) 2011.03.28
      ;; Solved the problem : if a point at the given polygon , it perhap return T or NIL .
      (cond
        ((vl-some (function (lambda (x) (equal x pt fuzz))) pts)
         0
        )
        ((and
           (equal
             (abs
               (apply
                 (function +)
                 (mapcar
                   (function
                     (lambda (x y / a)
                             (setq a (rem (- (angle pt x) (angle pt y)) pi))
                       (if (equal (distance x y) (+ (distance pt x) (distance pt y)) *gsls_disfuzz*)
                         (setq at T)
                       )
                       a
                     )
                   )
                   (cons (last pts) pts)
                   pts
                 )
               )
             )
             pi
             fuzz
           )
           (not at)
         )
         1
        )
        (at 0)
        (-1)
      )
    )    ; end (pipl? pt pts fuzz)
    ;; get closed polygon's area
    (defun ss-pts2area (l)
      (/
        (apply
          (function +)
          (mapcar (function (lambda (x y)
                                    (- (* (car x) (cadr y)) (* (car y) (cadr x)))
                            )
                  )
                  (cons (last l) l)
                  l
          )
        )
         2.0
      )
    )    ; end (ss-pts2area l)
    ;; round
    (defun round (a jd / b s)
      ;; a -- a number or a number list,
      ;; jd -- Precision digits , decimal is a positive , integer is negative
      ;; e.g. (round 3.14159 3) --> 3.142 , (round 314159 -3) --> 314200
      ;;      (round '(2.567 3.141) 2) --> '(2.57 3.14)
      ;; by GSLS(SS) May , 2014 
      (cond
        ((numberp a)
           (setq b (expt 10.0 jd)
                 s (sign a)
           )
           (/ (fix (+ (* a b) (* 0.5 s))) b)
        )
        ((listp a)
         (mapcar (function (lambda (a) (round a jd))) a)
        )
      )
    )    ; end (round a jd)
    ;;
    (defun sign (x)
      (cond
        ((minusp x)
         -1.0
        )
        (1.0)
      )
    )    ; end (sign x)
    ;;
    (defun eqmember (p l fuzz)
      (cond
        ((not l)
         nil
        )
        ((if (numberp fuzz)
           (equal p (car l) fuzz)
           (equal p (car l))
         )
         l
        )
        (t
          (eqmember p (cdr l) fuzz)
        )
      )
    )    ; end (eqmember p l fuzz)
    ;;
    (defun remove-same-pts (lst fuzz / l)
      (if lst
        (foreach a lst
          (if (not (eqmember a l fuzz))
            (setq l (cons a l))
          )
        )
      )
      (reverse l)
    )    ; end (remove-same-pts lst fuzz)
    ;;
    (defun remove-nth (i lst / j len fst)
      ;; by GSLS(SS)
      (if (/= (type i) (quote list))
        (cond
          ((or (minusp i) (> i (1- (setq len (length lst)))))
           lst
          )
          ((> i (/ len 2))
           (reverse (remove-nth (1- (- len i)) (reverse lst)))
          )
          (t
            (append
              (progn
                (setq fst nil)
                (repeat (rem i 4)
                  (setq fst (cons (car lst) fst)
                        lst (cdr lst)
                  )
                )
                (repeat (/ i 4)
                  (setq fst (vl-list* (cadddr lst)
                                      (caddr lst)
                                      (cadr lst)
                                      (car lst)
                                      fst
                            )
                        lst (cddddr lst)
                  )
                )
                (reverse fst)
              )
              (cdr lst)
            )
          )
        )
        (progn
          (setq j (cadr i)
                i (car i)
          )
          (if j
            (mapcar (function (lambda (x) (remove-nth j x)))
                    (remove-nth i lst)
            )
            (remove-nth i lst)
          )
        )
      )
    )    ; end (remove-nth i lst)
    ;;
    (defun tcgroup (l / sej a c r)
      ;; Cycle Group of a list split by nil-items 
      ;; (tcgroup '(nil 1 2 3 nil nil 4 5 6 nil 7))-> '((1 2 3) (4 5 6) (7))
      ;; (tcgroup '(1 2 nil 3 4 5 nil 6)) -> '((6 1 2) (3 4 5))
      (if (and (car l) (last l))
        (setq sej T)
      )
      (while l
        (setq a (car l)
              l (cdr l)
        )
        (if (and a (setq c (list a)))
          (while (car l)
            (setq c (cons (car l) c)
                  l (cdr l)
            )
          )
          (setq c nil)
        )
        (if c
          (setq r (cons (reverse c) r))
        )
      )
      (if sej
        (cons (append (car r) (last r)) (cdr (reverse (cdr r))))
        (reverse r)
      )
    )    ; end (tcgroup l)
    ;;
    (defun eqgroup (l fq fuzz / j c r)
      ;; join neighbor element's value get by function fq is equal by pricision fuzz into a group
      ;; (eqgroup '((1 2) (1 3) (2 3) (3 4) (5 4)) cadr 1e-3)-->'(((1 2)) ((1 3) (2 3)) ((3 4) (5 4)))
      ;; (eqgroup '((1 2) (1 3) (2 3) (3 4) (5 4)) car 1e-3) -->'(((1 2) (1 3)) ((2 3)) ((3 4)) ((5 4)))
      (while l
        (setq j (car l)
              l (cdr l)
              c (list j)
        )
        (while (equal (fq j) (fq (car l)) fuzz)
          (setq c (cons (car l) c)
                l (cdr l)
          )
        )
        (setq r (cons (reverse c) r))
      )
      (reverse r)
    )    ; end (eqgroup l fq fuzz)
    ;;
    (defun assoc2 (n l / a)
      (if (setq a (assoc n l))
        (list a (cadr (member a l)))
      )
    )    ; end (assoc2 n l)
    ;;
    ;; Entity to Point List  -  M.R.
    ;; Returns a list of points describing or approximating the supplied entity, else nil if the entity is not supported.
    ;; ent - [ent] Entity name to be described by point list (POINT/LINE/ARC/CIRCLE/LWPOLYLINE/POLYLINE/ELLIPSE/SPLINE/HELIX)
    ;; acc - [num] Positive number determining the point density for non-linear objects

    (defun MR:ent->pts (ent acc / der di1 di2 enx inc lst par fds fdm)

      (vl-load-com)

      (setq enx (entget ent))
      (cond
        ((= "POINT" (cdr (assoc 0 enx)))
         (list (cdr (assoc 10 enx)))
        )
        ((= "LINE" (cdr (assoc 0 enx)))
         (list (cdr (assoc 10 enx)) (cdr (assoc 11 enx)))
        )
        ((wcmatch (cdr (assoc 0 enx)) "ARC,CIRCLE")
                  (setq di1 0.0
                        di2 (vlax-curve-getdistatparam ent (vlax-curve-getendparam ent))
                        inc (/ di2 acc)
                        di2 (- di2 1e-8)
                  )
           (while (< di1 di2)
             (setq lst (cons (vlax-curve-getpointatdist ent di1) lst)
                   di1 (+ di1 inc)
             )
           )
           (reverse (if (vlax-curve-isclosed ent) lst (cons (vlax-curve-getendpoint ent) lst)))
        )
        ((and (wcmatch (cdr (assoc 0 enx)) "*POLYLINE") (zerop (logand 80 (cdr (assoc 70 enx)))))
         (setq par 0)
          (repeat (fix (+ 1.0 1e-8 (vlax-curve-getendparam ent)))
            (cond
              ((not (setq der (vlax-curve-getsecondderiv ent par))))
              ((equal der '(0.0 0.0 0.0) 1e-8)
                (if (/= par (vlax-curve-getendparam ent))
                  (setq lst (cons (vlax-curve-getpointatparam ent par) lst))
                )
              )
              ((not (equal der '(0.0 0.0 0.0) 1e-8))
                (if (/= par (vlax-curve-getendparam ent))
                  (progn
                    (setq di1 (vlax-curve-getdistatparam ent par)
                          di2 (vlax-curve-getdistatparam ent (1+ par))
                    )
                    (setq inc (/ (- di2 di1) acc)
                          di2 (- di2 1e-8)
                    )
                    (while (< di1 di2)
                      (setq lst (cons (vlax-curve-getpointatdist ent di1) lst)
                            di1 (+ di1 inc)
                      )
                    )
                  )
                )
              )
            )
            (setq par (1+ par))
          )
           (reverse (if (vlax-curve-isclosed ent) lst (cons (vlax-curve-getendpoint ent) lst)))
        )
        ((wcmatch (cdr (assoc 0 enx)) "SPLINE,ELLIPSE,HELIX")
                  (setq di1 (vlax-curve-getdistatparam ent (vlax-curve-getstartparam ent))
                        di2 (vlax-curve-getdistatparam ent (vlax-curve-getendparam ent))
                        inc (/ (- di2 di1) acc)
                        di2 (- di2 1e-8)
                  )
           (while (< di1 di2)
             (setq fds (cons (distance '(0.0 0.0 0.0) (vlax-curve-getfirstderiv ent (vlax-curve-getparamatdist ent di1))) fds)
                   di1 (+ di1 (distance '(0.0 0.0 0.0) (vlax-curve-getfirstderiv ent (vlax-curve-getparamatdist ent di1))))
             )
           )
           (setq di1 (vlax-curve-getdistatparam ent (vlax-curve-getstartparam ent)))
           (setq fdm (apply (function max) fds))
          (while (< di1 di2)
            (setq lst (cons (vlax-curve-getpointatdist ent di1) lst)
                  di1 (+ di1 (* (/ (distance '(0.0 0.0 0.0) (vlax-curve-getfirstderiv ent (vlax-curve-getparamatdist ent di1))) fdm) inc))
            )
          )
           (reverse (if (vlax-curve-isclosed ent) lst (cons (vlax-curve-getendpoint ent) lst)))
        )
      )
    )    ; end (MR:ent->pts ent acc)
    ;;
    ;;------------------------------------------------------------;;
    ;;  Author: Lee Mac, Copyright ?2011 - www.lee-mac.com        ;;
    ;;------------------------------------------------------------;;
    ;;  Arguments:                                                ;;
    ;;  ent - Entity for which to return Point List.              ;;
    ;;------------------------------------------------------------;;
    ;;  Returns:  List of Points describing/approximating entity  ;;
    ;;------------------------------------------------------------;;
    (defun LM:Entity->PointList
      (ent / der di1 di2 di3 elst inc lst par rad)
      (setq elst (entget ent))
      (cond
        ((eq "POINT" (dxf 0 elst))
         (list (dxf 10 elst))
        )
        ((eq "LINE" (dxf 0 elst))
         (list (dxf 10 elst) (dxf 11 elst))
        )
        ((member (dxf 0 elst) (list "CIRCLE" "ARC"))
                 (setq di1 0.0
                       di2 (vlax-curve-getdistatparam
                             ent
                             (vlax-curve-getendparam ent)
                           )
                       inc (/
                             di2
                             (1+ (fix (* 35.0 (/ di2 (dxf 40 elst) (+ pi pi)))))
                           )
                       fun (if (vlax-curve-isclosed ent)
                             <
                             <=
                           )
                 )
           (while (fun di1 di2)
             (setq lst (cons (vlax-curve-getpointatdist ent di1) lst)
                   di1 (+ di1 inc)
             )
           )
           lst
        )
        ((or (eq (dxf 0 elst) "LWPOLYLINE")
             (and (eq (dxf 0 elst) "POLYLINE")
                  (zerop (logand (dxf 70 elst) 80))
             )
         )
           (setq par 0)
          (repeat (fix (1+ (vlax-curve-getendparam ent)))
            (if (setq der (vlax-curve-getsecondderiv ent par))
              (if (equal der (list 0.0 0.0 0.0) 1e-8)
                (setq lst (cons (vlax-curve-getpointatparam ent par) lst))
                (if (setq rad (distance (list 0.0 0.0)
                                        (vlax-curve-getfirstderiv ent par)
                              )
                          di1 (vlax-curve-getdistatparam ent par)
                          di2 (vlax-curve-getdistatparam ent (1+ par))
                    )
                  (progn
                    (setq
                      inc
                      (/ (- di2 di1)
                         (1+ (fix (* 35.0 (/ (- di2 di1) rad (+ pi pi)))))
                      )
                    )
                    (while (< di1 di2)
                      (setq lst (cons (vlax-curve-getpointatdist ent di1) lst)
                            di1 (+ di1 inc)
                      )
                    )
                  )
                )
              )
            )
            (setq par (1+ par))
          )
           (if (or (vlax-curve-isclosed ent)
                   (equal (list 0.0 0.0 0.0) der 1e-8)
               )
             lst
             (cons (vlax-curve-getendpoint ent) lst)
           )
        )
        ((eq (dxf 0 elst) "ELLIPSE")
             (setq di1 (vlax-curve-getdistatparam
                         ent
                         (vlax-curve-getstartparam ent)
                       )
                   di2 (vlax-curve-getdistatparam
                         ent
                         (vlax-curve-getendparam ent)
                       )
                   di3 (* di2
                          (/ (+ pi pi)
                             (abs (- (vlax-curve-getendparam ent)
                                     (vlax-curve-getstartparam ent)
                                  )
                             )
                          )
                       )
             )
           (while (< di1 di2)
             (setq lst (cons (vlax-curve-getpointatdist ent di1) lst)
                   der (distance (list 0.0 0.0)
                                 (vlax-curve-getsecondderiv
                                   ent
                                   (vlax-curve-getparamatdist ent di1)
                                 )
                       )
                   di1 (+ di1 (/ di3 (1+ (fix (/ 35.0 (/ di3 der (+ pi pi)))))))
             )
           )
           (if (vlax-curve-isclosed ent)
             lst
             (cons (vlax-curve-getendpoint ent) lst)
           )
        )
        ((eq (dxf 0 elst) "SPLINE")
             (setq di1 (vlax-curve-getdistatparam
                         ent
                         (vlax-curve-getstartparam ent)
                       )
                   di2 (vlax-curve-getdistatparam
                         ent
                         (vlax-curve-getendparam ent)
                       )
                   inc (/ di2 25.0)
             )
           (while (< di1 di2)
             (setq lst (cons (vlax-curve-getpointatdist ent di1) lst)
                   der (/ (distance (list 0.0 0.0)
                                    (vlax-curve-getsecondderiv
                                      ent
                                      (vlax-curve-getparamatdist ent di1)
                                    )
                          )
                          inc
                       )
                   di1 (+ di1
                         (if (equal 0.0 der 1e-10)
                           inc
                           (min inc (/ 1.0 der (* 10. inc)))
                         )
                       )
             )
           )
           (if (vlax-curve-isclosed ent)
             lst
             (cons (vlax-curve-getendpoint ent) lst)
           )
        )
      )
    )    ; end (LM:Entity->Pointlist ent)
    ;;
    (defun midpt (p1 p2)
      (mapcar (function (lambda (x y) (/ (+ x y) 2.0))) p1 p2)
    )    ; end (midpt p1 p2)
    ;;
    (defun errf (errn errm)
      (cond
        ((and
           (assoc 70 a)
           (setq a (nth (format-i (1- (caar s)) n) rgl))
           (setq p0 (pnth (cadar a))
                 a0 (cdaar a)
           )
              (setq p1 (ray-int-line p0 a0 (pnth (assoc 10 (cadr a))) p))
              (not (equal p1 p *gsls_disfuzz*))
              ;_after neighbor closed , it's new ray no always must be join determining 
              (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
              (or
                (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
                (< (distance p0 p1) (distance p0 p2))
              )
         )
        )
        ((and
           (assoc 70 c)
           (setq c (nth (format-i (1+ (caar s)) n) rgl))
           (setq p0 (pnth (cadadr c))
                 a0 (cdaadr c)
           )
              (setq p1 (ray-int-line p0 a0 (pnth (assoc 10 (car c))) p))
              (not (equal p1 p *gsls_disfuzz*))
              ;_after neighbor closed , it's new ray no always must be join determining 
              (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
              (or
                (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))
                (< (distance p0 p1) (distance p0 p2))
              )
         )
        )
        ;; according RibarM's catched error :  first vertex error joined , add first determine
        ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
        ((vl-some (function (lambda (i / p0 p1 p2 p3)
                                    (or (= (format-i (+ i errm) n) (caar s))
                                        (= (format-i (- i errn) n) (caar s))
                                    )
                            )
                  )
                  closed_il
         )
        )
        (t
          (if (not (setq i (_vl-position-fuzz p tl 1e-6)))
            (setq tl (append tl (list p))
                  zl (append zl (list (caddr s)))
                  i (1- (length tl))
            )
          )
           (setq b (nth (caar s) rgl)
                 b1 (list (add-item i nil (car b)) (add-item i nil (cadr b)) (cons 70 1))
                 rgl (subst b1 b rgl)
                 closed_n (1+ closed_n)
                 closed_il (cons (caar s) closed_il)
           )
           ;;deal near side info
           (if
             (and
               (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
               (setq fi (suit-i (cadar s) 1+))
               (/= bi fi)
             )
             (setq a (nth bi rgl)
                   c (nth fi rgl)
                   p0 (nth (dxf 10 (car a)) pl)
                   p1 (nth (dxf 10 (cadr a)) pl)
                   p2 (nth (dxf 10 (car c)) pl)
                   p3 (nth (dxf 10 (cadr c)) pl)
                   an (bisector2 p0 p1 p2 p3)
                   a1 (list (car a) (add-item i an (cadr a)))
                   c1 (list (add-item i an (car c)) (cadr c))
                   rgl (subst a1 a rgl)
                   rgl (subst c1 c rgl)
             )
           )
        )
      )
    )    ; end (errf errn errm)
    ;;

    (defun mainprocess (mode / pre-sub main-sub)

      (defun pre-sub nil
        ;; ray end point list
        (setq pl1 (append (cdr pl) (list (car pl))))
        (setq rel
              (mapcar
                (function
                  (lambda (a / i ii p b p1)
                          (setq i (car a)
                                a (cdr a)
                                p (nth i pl)
                                b (list (format-i (1- i) n) i)
                                ii -1
                          )
                          (setq p1
                                (car-sort
                                  (vl-remove nil
                                             (mapcar
                                               (function
                                                 (lambda (p0 p1)
                                                   (if (not (member (setq ii (1+ ii)) b))
                                                     (ray-int-line p a p0 p1)
                                                   )
                                                 )
                                               )
                                                     pl pl1
                                             )
                                  )
                                          (function
                                            (lambda (p0 p1)
                                                    (< (distance p0 p) (distance p1 p))
                                            )
                                          )
                                )
                          )
                          (car-sort
                            (vl-remove nil
                                       (list
                                         (midpt p p1)
                                         (ray-inters p a (nth (car b) pl) (dxf (car b) bl))
                                         (ray-inters p a (nth (setq i (format-i (1+ i) n)) pl) (dxf i bl))
                                       )
                            )
                                    (function
                                      (lambda (p0 p1)
                                              (< (distance p0 p) (distance p1 p))
                                      )
                                    )
                          )
                  )
                )
                bl
              )
        )
        ;; find first suitable ray-intersections
        (setq il
              (mapcar
                (function
                  (lambda (s / s1 s2 p z)
                          (setq s1 (nth (car s) bl)  ;_(setq s (list 19 20))
                                s2 (nth (cadr s) bl)
                                p (ray-inters (nth (car s1) pl) (cdr s1) (nth (car s2) pl) (cdr s2))
                          )
                          (if
                            (and
                              p
                              (> (pipl? p pl *gsls_angfuzz*) 0)
                              (setq z (suit0 p (list (car s) (format-i (1- (car s)) n) (cadr s))))
                            )
                            (list s p z)
                          )
                  )
                )
                sl
              )
        )
        ;; deal neighbor is closed .
        ;; Edited 6.3-2014 , if neighbors number >= 3 , it shoud be Interval returns , until neighbors have same z valve .  
        (setq il (tcgroup il))
        ;; improve determine neighbor more than 2 item .
        ;; for 3 items z valve : {max min max} -> { min } , {min mid max} -> {min max} , {min max mid}-> {min mid}
        ;;                       {min min max} -> {min min} , {min max1 max2} -> {min max2} , {min min min} -> {min min min}
        (setq il
              (mapcar
                (function
                  (lambda (a / z b c d e ir i)       ;_(setq a (nth 1 il) d nil e nil)
                          (setq z (caddr (car-sort a (function (lambda (x y) (< (caddr x) (caddr y)))))))
                    (cond
                      ((not (cadr a))
                       a
                      )
                      ((not (caddr a))
                            (vl-remove-if-not
                              (function
                                (lambda (x)
                                        (equal z (caddr x) *gsls_disfuzz*)
                                )
                              )
                              a
                            )
                      )
                      (t
                        (setq b (eqgroup a caddr *gsls_disfuzz*))
                        (setq c (car (vl-remove-if-not (function (lambda (x) (equal z (caddar x) *gsls_disfuzz*))) b))
                              ir (rem (_vl-position-fuzz c b 1e-6) 2)
                              i 0
                        )
                         (mapcar
                           (function
                             (lambda (x)
                               (if (= (rem i 2) ir)
                                 (setq d (cons x d))
                                 (setq e (cons x e))
                               )
                                     (setq i (1+ i))
                             )
                           )
                           b
                         )
                         (mapcar
                           (function car)
                           (append
                             d
                             (vl-remove-if-not (function (lambda (x) (equal z (caddar x) *gsls_disfuzz*))) e)
                           )
                         )
                      )
                    )
                  )
                )
                il
              )
              il (apply (function append) il)
              il (_vl-sort il (function (lambda (a b) (< (caddr a) (caddr b)))))
        )
        ;; add first suitable intersections into it's side info , put them closed .
        (setq closed_n 0)
        (foreach s il
          (setq p (cadr s))
          (setq a (nth (format-i (- (caar s) 2) n) rgl)
                c (nth (format-i (+ (caar s) 2) n) rgl)
          )
          ;; add whether the neighbor closed first .
          (if (and errn errm)
            (errf errn errm)
          )
        )
      )  ;;; pre-sub

      (defun main-sub nil
        ;; release error closed or crash side 
        (foreach b rdl
          (setq b (cadr b)
                i (dxf 10 (car b))
                bi (format-i (- i 2) n)
                fi (format-i (+ i 2) n)
          )
          (setq
            a (if (member bi closed_il)
                (assoc2 12 (car (nth (format-i (1- i) n) rgl)))
              )
            c (if (member fi closed_il)
                (assoc2 12 (cadr (nth (format-i (1+ i) n) rgl)))
              )
          )
          (if (vl-some (function (lambda (a / p0 a1 p1 p2)
                                         (and
                                           a
                                           (cadr a)
                                           (caar b)
                                           (cadar b)
                                           (caadr b)
                                           (cadadr b)
                                           (setq p0 (pnth (cadr a))
                                                 a1 (cdar a)
                                           )
                                              (setq p1 (ray-int-line p0 a1 (pnth (caar b)) (pnth (cadar b))))
                                              (setq p2 (ray-int-line p0 a1 (pnth (caadr b)) (pnth (cadadr b))))
                                              (not (equal p1 p2 *gsls_disfuzz*))
                                         )
                                 )
                       )
                       (list a c)
              )
            (setq rgl
                  (subst
                    (list
                      (list (cons 12 (dxf (dxf 10 (car b)) bl)) (assoc 10 (car b)))
                      (list (cons 12 (dxf (dxf 10 (cadr b)) bl)) (assoc 10 (cadr b)))
                    )
                         b rgl
                  )
                  closed_n (1- closed_n)
                  closed_il (vl-remove i closed_il)
                  ril (cons i ril)  ;_sign just break closed_i , 6.23-2014
                  a (nth (format-i (1- i) n) rgl)
                  c (nth (format-i (1+ i) n) rgl)
                  a1 (list
                       (car a)
                       (cons (cons 12
                               (if (= (caaddr (cadr a)) 10)
                                 (dxf (cdaddr (cadr a)) bl)
                                 (if (and (caddr (cadr a)) (cadadr a))
                                   (angle (pnth (caddr (cadr a))) (pnth (cadadr a)))
                                 )
                               )
                             )
                             (cddadr a)
                       )
                     )
                  c1 (list
                       (cons (cons 12
                               (if (= (caaddr (car c)) 10)
                                 (dxf (cdaddr (car c)) bl)
                                 (if (and (caddar c) (cadar c))
                                   (angle (pnth (caddar c)) (pnth (cadar c)))
                                 )
                               )
                             )
                             (cddar c)
                       )
                           (cadr c)
                     )
                  rgl (subst a1 a rgl)
                  rgl (subst c1 c rgl)
            )
          )
        )
        ;; neighbor is closed 
        (setq il
              (vl-remove nil
                         (mapcar
                           (function
                             (lambda (r / s1 s2 p z)
                               (if
                                 (and
                                   (not (assoc 70 r))
                                   (not (member (dxf 10 (car r)) ril))  ;_add  side closed has been break , 6.26-2014
                                   (= (length (car r)) (length (cadr r)) 2)
                                   (setq s1 (car r)
                                         s2 (cadr r)
                                         p (ray-inters (nth (cdadr s1) pl) (cdar s1) (nth (cdadr s2) pl) (cdar s2))
                                   )
                                   (> (pipl? p pl *gsls_angfuzz*) 0)
                                   (setq z (suit p (list (cdadr s1) (format-i (1- (cdadr s1)) n) (cdadr s2))))
                                 )
                                 (list (cdadar r) z p r)
                               )
                             )
                           )
                           rgl
                         )
              )
        )
        (while il
          (setq a (car il)
                b (cadr il)
                il (cdr il)
          )
          (cond
            ((or (not b) (/= (format-i (1+ (car a)) n) (car b)))
             (setq ill (cons a ill))
            )
            ((<= (cadr a) (cadr b))
                 (setq ill (cons a ill)
                       il (cdr il)
                 )
            )
          )
        )
        (setq il (_vl-sort (mapcar (function cdr) (reverse ill)) (function (lambda (a b) (<= (car a) (car b))))))
        (foreach ip il
          (setq z (car ip)
                p (cadr ip)
                b (caddr ip)
          )
          (if (not (setq i (_vl-position-fuzz p tl 1e-6)))
            (setq tl (append tl (list p))
                  zl (append zl (list z))
                  i (1- (length tl))
            )
          )
          (setq b1 (list (add-item i nil (car b)) (add-item i nil (cadr b)) (cons 70 1))
                rgl (subst b1 b rgl)
                closed_n (1+ closed_n)
                closed_il (cons (dxf 10 (car b)) closed_il)
          )
          (if
            (and
              (setq bi (suit-i (format-i (1- (dxf 10 (car b))) n) 1-))
              (setq fi (suit-i (dxf 10 (cadr b)) 1+))
              (/= bi fi)
            )
            (setq a (nth bi rgl)
                  c (nth fi rgl)
                  p0 (nth (dxf 10 (car a)) pl)
                  p1 (nth (dxf 10 (cadr a)) pl)
                  p2 (nth (dxf 10 (car c)) pl)
                  p3 (nth (dxf 10 (cadr c)) pl)
                  an (bisector2 p0 p1 p2 p3)
                  a1 (list (car a) (add-item i an (cadr a)))
                  c1 (list (add-item i an (car c)) (cadr c))
                  rgl (subst a1 a rgl)
                  rgl (subst c1 c rgl)
            )
          )
        )
        ;;;--------------------------------------------------------------------
        ;; check single no closed side's ray crash closed side
        (setq il (_getsinglenoclosed))  ;_here has a problem , maybe error deal one side ...
        (foreach i il
          (if (and (cadar (nth i rgl)) (cadadr (nth i rgl)))
            (progn
              (setq a (nth i rgl)
                    p0 (pnth (cadar a))
                    a0 (cdaar a)
                    p1 (pnth (cadadr a))
                    a1 (cdaadr a)
                    i+ (format-i (1+ i) n)
                    i- (format-i (1- i) n)
                    ill nil
                    l (append (cdar a) (cdadr a))
              )

              ;; only check near closed zone.
;|
              (while (member i+ closed_il)
                (setq ill (cons i+ ill)
                      i+ (format-i (1+ i+) n)
                )
              )
              (while (member i- closed_il)
                (setq ill (cons i- ill)
                      i- (format-i (1- i-) n)
                )
              )
|;

              ;;; Not good suggestion, testing should be near all closed zones... Mod. by M.R.
              (setq ill closed_il)

              ;; have shared vertices
              (setq ill
                    (vl-remove-if-not
                      (function
                        (lambda (i / b)
                                (setq b (nth i rgl)
                                      b (list (cadar b) (cadadr b))
                                )
                                (vl-some (function (lambda (x) (vl-position x l))) b)
                        )
                      )
                                      ill
                    )
              )
              ;; crashed ?
              (setq crl
                    (vl-remove nil
                               (mapcar
                                 (function
                                   (lambda (i / fc b pa pb pc pd pe pf p2)
                                     (defun fc ()
                                       (if (equal pe pa *gsls_disfuzz*)
                                         (setq pe nil)
                                       )
                                       (if (equal pf pa *gsls_disfuzz*)
                                         (setq pf nil)
                                       )
                                       (cond
                                         ((and pe pf)
                                           (cond
                                             ((< (distance p0 pe) (distance p0 pf))
                                              (setq p2 pe)
                                             )
                                             ((setq p2 pf))
                                           )
                                         )
                                         (pe
                                           (setq p2 pe)
                                         )
                                         (pf
                                           (setq p2 pf)
                                         )
                                       )
                                     )
                                     (setq b (nth i rgl))
                                     (if (and (assoc 70 b) (caar b) (cadar b) (cadadr b))
                                       (progn
                                         (setq pa (pnth (caar b))
                                               pb (pnth (cadar b))
                                               pc (pnth (cadadr b))
                                         )
                                         (cond
                                           ((equal (caar b) (cadadr a))
                                                   (setq pe (ray-int-line p0 a0 pa pb)
                                                         pf (ray-int-line p0 a0 pa pc)
                                                   )
                                              (fc)
                                             (if (and p2 (not (l_int_pl p0 p2 pl)))
                                               (list "for" p2 i)
                                             )
                                           )
                                           ((setq pe (ray-int-line p1 a1 pa pb)
                                                  pf (ray-int-line p1 a1 pa pc)
                                            )
                                              (fc)
                                             (if (and p2 (not (l_int_pl p1 p2 pl)))
                                               (list "back" p2 i)
                                             )
                                           )
                                         )
                                       )
                                     )
                                   )
                                 )
                                 ill
                               )
                    )
              )
              (cond
                ((and crl (= (caar crl) "back"))
                      (setq crl (_vl-sort crl (function (lambda (x y) (< (distance p1 (cadr x)) (distance p1 (cadr y))))))
                            cr (car crl)
                      )
                )
                ((and crl (= (caar crl) "for"))
                      (setq crl (_vl-sort crl (function (lambda (x y) (< (distance p0 (cadr x)) (distance p0 (cadr y))))))
                            cr (car crl)
                      )
                )
              )
              (if
                (and
                  cr
                  (setq ty (car cr)
                        p2 (cadr cr)
                        b (nth (caddr cr) rgl)
                  )
                     (assoc 70 b)
                     (cadar b)
                     (caar b)
                     (cadadr b)
                     (caadr b)
                )
                (progn
                  (setq
                    a2 (angle (pnth (cadar b)) (pnth (caar b)))
                    a3 (angle (pnth (cadadr b)) (pnth (caadr b)))
                    rgl (subst (list (cons (cons 12 a2) (cdar b)) (cons (cons 12 a3) (cdadr b))) b rgl)
                    closed_n (1- closed_n)
                    closed_il (vl-remove (caddr cr) closed_il)
                  )
                  (cond
                    ((= ty "for")
                     (setq rgl (subst (list (car a) (cons (cons 12 a2) (cddadr a))) a rgl))
                     (setq c (nth (suit-i (format-i (1+ (dxf 10 (car b))) n) 1+) rgl))
                     (setq rgl (subst (list (cons (cons 12 a3) (cddar c)) (cadr c)) c rgl))
                    )
                    ((= ty "back")
                     (setq rgl (subst (list (cons (cons 12 a3) (cddar a)) (cadr a)) a rgl))
                     (setq c (nth (suit-i (format-i (1- (dxf 10 (car b))) n) 1-) rgl))
                     (setq rgl (subst (list (car c) (cons (cons 12 a2) (cddadr c))) c rgl))
                    )
                  )
                )
              )
            )
          )
        )
      )  ;;; main-sub

      (cond
        ((null mode)
         (pre-sub)
         ;;; deal near side of closed-side , until catch another closed side
         ;;;--------------------------------------------------------------------
         ;; deal has closed side .
         (_closed)
;|
          (setq *gsls_disfuzz* (* *gsls_disfuzz* 2)
                *gsls_angfuzz* (* *gsls_angfuzz* 10)
          )
|;
         (foo)
         (_getclosed)
         ;;; here must reopen error first closed side . and reclosed the first lost closed side .
         ;;; Edited June 17 2014       
         (main-sub)
;|
          (setq *gsls_disfuzz* (* *gsls_disfuzz* 2)
                *gsls_angfuzz* (* *gsls_angfuzz* 10)
          )
|;
         (foo1)
;|
          (setq *gsls_angfuzz* (* *gsls_angfuzz* 5)
                *gsls_disfuzz* (* *gsls_disfuzz* 2.5)
          )
|;
         (_closed2)
        )
        (t
          (pre-sub)
          ;;; deal near side of closed-side , until catch another closed side
          ;;;--------------------------------------------------------------------
          ;; deal has closed side .
          (_closed)
;|
          (setq *gsls_disfuzz* (* *gsls_disfuzz* 2)
                *gsls_angfuzz* (* *gsls_angfuzz* 10)
          )
|;
          (foo-n)
          (_getclosed)
          (_closed)
          (foo-n)
          (_getclosed)
          ;;; here must reopen error first closed side . and reclosed the first lost closed side .
          ;;; Edited June 17 2014       
          (main-sub)
;|
          (setq *gsls_disfuzz* (* *gsls_disfuzz* 2)
                *gsls_angfuzz* (* *gsls_angfuzz* 10)
          )
|;
          (foo1-n)
;|
          (setq *gsls_angfuzz* (* *gsls_angfuzz* 5)
                *gsls_disfuzz* (* *gsls_disfuzz* 2.5)
          )
|;
          (_closed2)
        )
      )
    )    ;;; mainprocess

    (defun postprocess (rgl)
      (foreach r rgl
        (if (assoc 70 r)
          (mapcar
            (function
              (lambda (a / b)
                      (setq b (mapcar (function (lambda (a) (pnth a))) a))
                      (mapcar (function (lambda (c d)
                                                (setq li (cons (list c d) li))
                                        )
                              )
                              b
                              (cdr b)
                      )
              )
            )
            (list (car r) (cadr r))
          )
        )
      )
      (while li
        (if
          (not
            (vl-some (function (lambda (x)
                                       (or (and (equal (car x) (caar li) 1e-8)
                                                (equal (cadr x) (cadar li) 1e-8)
                                           )
                                           (and (equal (cadr x) (caar li) 1e-8)
                                                (equal (car x) (cadar li) 1e-8)
                                           )
                                       )
                               )
                     )
                     (cdr li)
            )
          )
          (setq ll (cons (car li) ll))
        )
        (setq li (cdr li))
      )
      (setq lll ll)
      (while (setq li (car lll))
        (cond
          ((setq la (vl-some (function (lambda (x) (if (and (collinear-p (car li) (cadr li) (car x)) (collinear-p (car li) (cadr li) (cadr x)) (equal (distance (car li) (cadr li)) (+ (distance (car li) (car x)) (distance (car x) (cadr li))) 1e-6) (equal (cadr li) (cadr x) 1e-6) (not (equal (car li) (car x) 1e-6))) x))) (vl-remove li ll)))
           (setq ll (vl-remove li ll) ll (cons (list (car li) (car la)) ll))
          )
          ((setq la (vl-some (function (lambda (x) (if (and (collinear-p (car li) (cadr li) (car x)) (collinear-p (car li) (cadr li) (cadr x)) (equal (distance (car li) (cadr li)) (+ (distance (car li) (car x)) (distance (car x) (cadr li))) 1e-6) (equal (car li) (cadr x) 1e-6) (not (equal (cadr li) (car x) 1e-6))) x))) (vl-remove li ll)))
           (setq ll (vl-remove li ll) ll (cons (list (cadr li) (car la)) ll))
          )
          ((setq la (vl-some (function (lambda (x) (if (and (collinear-p (car li) (cadr li) (car x)) (collinear-p (car li) (cadr li) (cadr x)) (equal (distance (car li) (cadr li)) (+ (distance (car li) (cadr x)) (distance (cadr x) (cadr li))) 1e-6) (equal (cadr li) (car x) 1e-6) (not (equal (car li) (cadr x) 1e-6))) x))) (vl-remove li ll)))
           (setq ll (vl-remove li ll) ll (cons (list (car li) (cadr la)) ll))
          )
          ((setq la (vl-some (function (lambda (x) (if (and (collinear-p (car li) (cadr li) (car x)) (collinear-p (car li) (cadr li) (cadr x)) (equal (distance (car li) (cadr li)) (+ (distance (car li) (cadr x)) (distance (cadr x) (cadr li))) 1e-6) (equal (car li) (car x) 1e-6) (not (equal (cadr li) (cadr x) 1e-6))) x))) (vl-remove li ll)))
           (setq ll (vl-remove li ll) ll (cons (list (cadr li) (cadr la)) ll))
          )
        )
        (setq lll (vl-remove li lll))
      )
      (vl-some
        (function
          (lambda (li1)
            (if
              (vl-some
                (function
                  (lambda (li2 / p)
                          (and
                            (setq p (inters (car li1) (cadr li1) (car li2) (cadr li2)))
                            (not (equal p (car li1) 1e-6))
                            (not (equal p (cadr li1) 1e-6))
                          )
                  )
                )
                (vl-remove li1 ll)
              )
              (setq tst12 t)
            )
          )
        )
        ll
      )
    )    ;;; postprocess

    ;;------------------------------------main function------------------------------;;

    (defun start (pl errn errm / a a1 ab an b
                     bi bii bl c c1 cf closed_il closed_n
                     e fi fii i i% il ip0 ip1 li
                     ll n p p0 p1 p2 p3 rdl rgl
                     i rml rnl sil sl ti tl z zl
                     rel pl1 b1 i+ i- crl cr a0 a2
                     a3 ill rgl11 tst11 tst12 d rxl rx y
                     cps qq rglb k rgll1 rgll2 ip l tl1
                     tl2  ;_local variables
                 )

      (setq _2pi 6.283185307179586476925286766559
            _pi2 1.5707963267948966192313216916395
            *gsls_angfuzz* 1e-7
            *gsls_disfuzz* 1e-3
      )

      ;; build side message 
      (setq n (length pl)
            i -1
      )
      (setq sl
            (mapcar
              (function
                (lambda (a)
                        (setq i (1+ i))
                  (if (= (1+ i) n)
                    (list i 0)
                    (list i (1+ i))
                  )
                )
              )
                    pl
            )
      )
      ;; build inter-bisector angle list with point index 
      (setq bl (lbisector pl))
      ;; build start result list , each side with two construction list
      ;; dxf code : 10 -- point of pl , 11 -- point of tl (inter points) , 12 -- ray angle of last point  , 70 -- closed mark 
      (setq rgl
            (mapcar
              (function
                (lambda (s)
                        (list
                          (list (cons 12 (cdr (nth (car s) bl))) (cons 10 (car s)))
                          (list (cons 12 (cdr (nth (cadr s) bl))) (cons 10 (cadr s)))
                        )
                )
              )
              sl
            )
      )
      (mainprocess nil)
      (setq rgll1 rgl tl1 tl)
      (setq a nil a1 nil ab nil an nil b nil bi nil bii nil
            bl nil c nil c1 nil cf nil closed_il nil closed_n nil d nil
            e nil fi nil fii nil i nil i% nil il nil ip0 nil ip1 nil li nil
            n nil p nil p0 nil p1 nil p2 nil p3 nil rdl nil rgl nil
            i nil rml nil rnl nil sil nil sl nil ti nil tl nil z nil zl nil
            rel nil pl1 nil b1 nil i+ nil i- nil crl nil cr nil a0 nil a2 nil
            a3 nil ill nil rgl11 nil tst11 nil tst12 nil ip nil l nil
      )
      (setq *gsls_angfuzz* 1e-7
            *gsls_disfuzz* 1e-3
      )
      ;; build side message 
      (setq n (length pl)
            i -1
      )
      (setq sl
            (mapcar
              (function
                (lambda (a)
                        (setq i (1+ i))
                  (if (= (1+ i) n)
                    (list i 0)
                    (list i (1+ i))
                  )
                )
              )
              pl
            )
      )
      ;; build inter-bisector angle list with point index 
      (setq bl (lbisector pl))
      ;; build start result list , each side with two construction list
      ;; dxf code : 10 -- point of pl , 11 -- point of tl (inter points) , 12 -- ray angle of last point  , 70 -- closed mark 
      (setq rgl
            (mapcar
              (function
                (lambda (s)
                        (list
                          (list (cons 12 (cdr (nth (car s) bl))) (cons 10 (car s)))
                          (list (cons 12 (cdr (nth (cadr s) bl))) (cons 10 (cadr s)))
                        )
                )
              )
              sl
            )
      )
      (mainprocess t)
      (setq rgll2 rgl tl2 tl)
      (setq rgl
        (cond
          ((>= (length (vl-remove-if-not (function (lambda (x) (assoc 70 x))) rgll1)) (length (vl-remove-if-not (function (lambda (x) (assoc 70 x))) rgll2)))
           rgll1
          )
          (t rgll2)
        )
      )
      (setq tl
        (cond
          ((>= (length (vl-remove-if-not (function (lambda (x) (assoc 70 x))) rgll1)) (length (vl-remove-if-not (function (lambda (x) (assoc 70 x))) rgll2)))
           tl1
          )
          (t tl2)
        )
      )
      (setq rgl11
            (vl-remove-if
              (function
                (lambda (x)
                        (/= (car x) 11)
                )
              )
              (apply (function append) (vl-remove '(70 . 1)
                                                  (apply (function append) rgl)
                     )
              )
            )
      )
      (foreach p11 (unique rgl11)
        (if (not (vl-position p11 (cdr (member p11 rgl11))))
          (setq tst11 (cons t tst11))
          (setq tst11 (cons nil tst11))
        )
      )
      (if
        (and
          (vl-every (function (lambda (x) (assoc 70 x)))
                    rgl
          )
          (not (apply (function or) tst11))
        )
        (progn
          (postprocess rgl)
          (if (not (vl-every (function (lambda (x) (vl-position x (apply (function append) ll)))) pll))
            (setq tst12 t)
          )
        )
        (if (not (vl-every (function (lambda (x) (assoc 70 x))) rgl))
          (progn
            (foreach r rgl
              (if (not (assoc 70 r))
                (setq rxl (cons r rxl))
              )
            )
            (setq rxl (reverse rxl))
            (setq rx (mapcar (function (lambda (x) (list (nth (cdr (assoc 10 (car x))) pl) (nth (cdr (assoc 10 (cadr x))) pl)))) rxl))
            (foreach x rx
              (if (setq y (vl-some (function (lambda (y) (if (and (collinear-p (car x) (cadr x) (car y)) (collinear-p (car x) (cadr x) (cadr y))) y))) (cdr (member x rx))))
                (setq cps (cons (cadr x) cpx) cps (cons (car y) cps))
              )
            )
            (setq cps (unique cps))
            (setq rx (mapcar (function (lambda (x) (list (if (not (vl-position (car x) cps)) (car x)) (if (not (vl-position (cadr x) cps)) (cadr x))))) rx))
            (foreach x rx
              (if (setq y (vl-some (function (lambda (y) (if (and (null (cadr x)) (null (car y))) y))) (cdr (member x rx))))
                (setq qq (cons (list (vl-position x rx) (vl-position y rx)) qq))
              )
            )
            (foreach q qq
              (setq k -1)
              (foreach r rgl
                (setq k (1+ k))
                (if (and (assoc 70 r) (< (vl-position (nth (car q) rxl) rgl) k (vl-position (nth (cadr q) rxl) rgl)))
                  (setq rglb (cons r rglb))
                )
              )
            )
            (if rglb
              (progn
                (postprocess rglb)
                (setq a nil a1 nil ab nil an nil b nil bi nil bii nil
                      bl nil c nil c1 nil cf nil closed_il nil closed_n nil d nil
                      e nil fi nil fii nil i nil i% nil il nil ip0 nil ip1 nil li nil
                      n nil p nil p0 nil p1 nil p2 nil p3 nil rdl nil rgl nil
                      i nil rml nil rnl nil sil nil sl nil ti nil tl nil z nil zl nil
                      rel nil pl1 nil b1 nil i+ nil i- nil crl nil cr nil a0 nil a2 nil
                      a3 nil ill nil rgl11 nil tst11 nil tst12 nil ip nil l nil
                )
                ;; build side message 
                (setq n (length pl)
                      i -1
                )
                (setq sl
                      (mapcar
                        (function
                          (lambda (a)
                            (setq i (1+ i))
                            (if (= (1+ i) n)
                              (list i 0)
                              (list i (1+ i))
                            )
                          )
                        )
                        pl
                      )
                )
                ;; build inter-bisector angle list with point index 
                (setq bl (lbisector pl))
                ;; build start result list , each side with two construction list
                ;; dxf code : 10 -- point of pl , 11 -- point of tl (inter points) , 12 -- ray angle of last point  , 70 -- closed mark 
                (setq rgl
                      (mapcar
                        (function
                          (lambda (s)
                                  (list
                                    (list (cons 12 (cdr (nth (car s) bl))) (cons 10 (car s)))
                                    (list (cons 12 (cdr (nth (cadr s) bl))) (cons 10 (cadr s)))
                                  )
                          )
                        )
                        sl
                      )
                )
                (foreach q qq
                  (setq a (car (vl-remove-if-not (function (lambda (x) (equal (assoc 10 (car (nth (car q) rxl))) (assoc 10 x)))) (mapcar (function car) rgl))))
                  (setq b (car (vl-remove-if-not (function (lambda (x) (equal (assoc 10 (cadr (nth (cadr q) rxl))) (assoc 10 x)))) (mapcar (function cadr) rgl))))
                  (setq c (vl-position (assoc a rgl) rgl))
                  (setq d (vl-position (vl-some (function (lambda (x) (if (equal b (cadr x)) x))) rgl) rgl))
                  (setq k -1)
                  (foreach p pl
                    (setq k (1+ k))
                    (if (< c k (1+ d))
                      (setq pl (vl-remove p pl))
                    )
                  )
                )
                (setq a nil a1 nil ab nil an nil b nil bi nil bii nil
                      bl nil c nil c1 nil cf nil closed_il nil closed_n nil d nil
                      e nil fi nil fii nil i nil i% nil il nil ip0 nil ip1 nil li nil
                      n nil p nil p0 nil p1 nil p2 nil p3 nil rdl nil rgl nil
                      i nil rml nil rnl nil sil nil sl nil ti nil tl nil z nil zl nil
                      rel nil pl1 nil b1 nil i+ nil i- nil crl nil cr nil a0 nil a2 nil
                      a3 nil ill nil rgl11 nil tst11 nil tst12 nil ip nil l nil
                )
                (setq *gsls_angfuzz* 1e-7
                      *gsls_disfuzz* 1e-3
                )
                ;; build side message 
                (setq n (length pl)
                      i -1
                )
                (setq sl
                      (mapcar
                        (function
                          (lambda (a)
                            (setq i (1+ i))
                            (if (= (1+ i) n)
                              (list i 0)
                              (list i (1+ i))
                            )
                          )
                        )
                        pl
                      )
                )
                ;; build inter-bisector angle list with point index 
                (setq bl (lbisector pl))
                ;; build start result list , each side with two construction list
                ;; dxf code : 10 -- point of pl , 11 -- point of tl (inter points) , 12 -- ray angle of last point  , 70 -- closed mark 
                (setq rgl
                      (mapcar
                        (function
                          (lambda (s)
                                  (list
                                    (list (cons 12 (cdr (nth (car s) bl))) (cons 10 (car s)))
                                    (list (cons 12 (cdr (nth (cadr s) bl))) (cons 10 (cadr s)))
                                  )
                          )
                        )
                        sl
                      )
                )
                (mainprocess nil)
                (setq rgll1 rgl tl1 tl)
                (setq a nil a1 nil ab nil an nil b nil bi nil bii nil
                      bl nil c nil c1 nil cf nil closed_il nil closed_n nil d nil
                      e nil fi nil fii nil i nil i% nil il nil ip0 nil ip1 nil li nil
                      n nil p nil p0 nil p1 nil p2 nil p3 nil rdl nil rgl nil
                      i nil rml nil rnl nil sil nil sl nil ti nil tl nil z nil zl nil
                      rel nil pl1 nil b1 nil i+ nil i- nil crl nil cr nil a0 nil a2 nil
                      a3 nil ill nil rgl11 nil tst11 nil tst12 nil ip nil l nil
                )
                (setq *gsls_angfuzz* 1e-7
                      *gsls_disfuzz* 1e-3
                )
                ;; build side message 
                (setq n (length pl)
                      i -1
                )
                (setq sl
                      (mapcar
                        (function
                          (lambda (a)
                            (setq i (1+ i))
                            (if (= (1+ i) n)
                              (list i 0)
                              (list i (1+ i))
                            )
                          )
                        )
                        pl
                      )
                )
                ;; build inter-bisector angle list with point index 
                (setq bl (lbisector pl))
                ;; build start result list , each side with two construction list
                ;; dxf code : 10 -- point of pl , 11 -- point of tl (inter points) , 12 -- ray angle of last point  , 70 -- closed mark 
                (setq rgl
                      (mapcar
                        (function
                          (lambda (s)
                                  (list
                                    (list (cons 12 (cdr (nth (car s) bl))) (cons 10 (car s)))
                                    (list (cons 12 (cdr (nth (cadr s) bl))) (cons 10 (cadr s)))
                                  )
                          )
                        )
                        sl
                      )
                )
                (mainprocess t)
                (setq rgll2 rgl tl2 tl)
                (setq rgl
                  (cond
                    ((>= (length (vl-remove-if-not (function (lambda (x) (assoc 70 x))) rgll1)) (length (vl-remove-if-not (function (lambda (x) (assoc 70 x))) rgll2)))
                     rgll1
                    )
                    (t rgll2)
                  )
                )
                (setq tl
                  (cond
                    ((>= (length (vl-remove-if-not (function (lambda (x) (assoc 70 x))) rgll1)) (length (vl-remove-if-not (function (lambda (x) (assoc 70 x))) rgll2)))
                     tl1
                    )
                    (t tl2)
                  )
                )
                (setq rgl11
                      (vl-remove-if
                        (function
                          (lambda (x)
                                  (/= (car x) 11)
                          )
                        )
                        (apply (function append) (vl-remove '(70 . 1)
                                                            (apply (function append) rgl)
                               )
                        )
                      )
                )
                (foreach p11 (unique rgl11)
                  (if (not (vl-position p11 (cdr (member p11 rgl11))))
                    (setq tst11 (cons t tst11))
                    (setq tst11 (cons nil tst11))
                  )
                )
                (if
                  (and
                    (vl-every (function (lambda (x) (assoc 70 x)))
                              rgl
                    )
                    (not (apply (function or) tst11))
                  )
                  (progn
                    (postprocess rgl)
                    (if (not (vl-every (function (lambda (x) (vl-position x (apply (function append) ll)))) pll))
                      (setq tst12 t)
                    )
                  )
                  (setq tst12 t)
                )
              )
              (setq tst12 t)
            )
          )
        )
      )
      (if (and tst12 (null fff))
        (if (< loopn nnn)
          (progn
            (if (null nrgl)
              (setq nrgl (length (vl-remove-if-not (function (lambda (x) (assoc 70 x))) rgl)) nrglt nrgl)
              (setq nrglt (length (vl-remove-if-not (function (lambda (x) (assoc 70 x))) rgl)))
            )
            (if (>= nrglt nrgl)
              (setq errnt errn errmt errm loopnt loopn nrgl nrglt)
            )
            (if (< errn (1- nnn))
              (setq ff t)
            )
            (cond
              ((and (= errn (1- nnn)) (= errm 0) (null ff))
               (setq errm -1 ff t)
              )
              ((and (= errn (1- nnn)) (/= errn 0) (null ff))
               (setq errm (1- errm) ff t)
              )
            )
            (setq errn (1+ errn))
            (if (= errn nnn)
              (setq errn 0 errm (1+ errm))
            )
            (if (= errm nnn)
              (setq errm 0 loopn (1+ loopn))
            )
            (setq a nil a1 nil ab nil an nil b nil bi nil bii nil
                  bl nil c nil c1 nil cf nil closed_il nil closed_n nil d nil
                  e nil fi nil fii nil i nil i% nil il nil ip0 nil ip1 nil li nil
                  ll nil n nil p nil p0 nil p1 nil p2 nil p3 nil rdl nil rgl nil
                  i%% nil rml nil rnl nil sil nil sl nil ti nil tl nil z nil zl nil
                  rel nil pl1 nil b1 nil i+ nil i- nil crl nil cr nil a0 nil a2 nil
                  a3 nil ill nil rgl11 nil tst11 nil tst12 nil rxl nil rx nil y nil cps nil
                  qq nil rglb nil k nil
            )
            (if (not (and (= loopn nnn) (= errn 0) (= errm 0)))
              (progn
                (prompt (strcat "\nLoop = " (itoa loopn) "\t\terrn = " (itoa errn) "\t\terrm = " (itoa errm)))
                (setq errntt errn errmtt errm loopntt loopn)
                (setq pl pll)
                (repeat loopn
                  (setq pl (append (cdr pl) (list (car pl))))
                )
                (start pl errn errm)
              )
            )
          )
        )
        (foreach l ll
          (setq lst
                (cons
                  (entmakex (list
                              (cons 0 "LINE")
                              (cons 10 (car l))
                              (cons 11 (cadr l))
                            )
                  )
                  lst
                )
          )
        )
      )
    )

    ;;------------------------------------main routine ------------------------------;;

    (prompt "\nPick a closed polygonal LWPOLYLINE...")
    (if (setq ent (ssget "_+.:E:S" (list (cons 0 "LWPOLYLINE") (cons -4 "&=") (cons 70 1) (cons -4 "<not") (cons -4 "<>") (cons 42 0.0) (cons -4 "not>"))))
      (progn
        (setq nnn (cdr (assoc 90 (entget (ssname ent 0)))))
        (initget 4)
        (setq loopn (getint (strcat "\nSpecify starting loop <0> (0-" (itoa (1- nnn)) ") : ")))
        (if (null loopn)
          (setq loopn 0)
        )
        (initget 4)
        (setq errn (getint (strcat "\nSpecify starting errn <0> (0-" (itoa (1- nnn)) ") : ")))
        (if (null errn)
          (setq errn 0)
        )
        (initget 4)
        (setq errm (getint (strcat "\nSpecify starting errm <0> (0-" (itoa (1- nnn)) ") : ")))
        (if (null errm)
          (setq errm 0)
        )
        (setq timee (car (_vl-times)))
        (setq #gsls_systemvar# (list "CMDECHO" "CLAYER"))
        ;(_svos)
        ;;;(setq pl (lm:entity->pointlist (ssname ent 0))) ;_for pl with arc
        (setq pl (mr:ent->pts (setq ent (ssname ent 0)) 90))
        (setq pl (remove-same-pts pl *gsls_disfuzz*))  ;_has doubles points in pl with arc
;|
        (if (< (ss-pts2area pl) 0) ;_force pointset CCW
          (setq pl (reverse pl))
        )
|;
        (vlax-invoke (vlax-ename->vla-object ent) 'offset -1e-3)
        (if (> (vlax-curve-getarea (entlast)) (vlax-curve-getarea ent))  ;_force pointset CCW
          (setq pl (reverse pl))
        )
        (entdel (entlast))
        (setq pll pl)
        (if (/= loopn 0)
          (repeat loopn
            (setq pl (append (cdr pl) (list (car pl))))
          )
        )
        (setq loopntt loopn errntt errn errmtt errm)
        (if (= errn 0)
          (start pl (1- nnn) errm)
          (start pl (1- errn) errm)
        )
        (prompt "\nElapsed time : ") (princ (rtos (/ (- (car (_vl-times)) timee) 1000.0) 2 50)) (prompt " seconds.")
        (if (/= loopn nnn)
          (prompt (strcat "\nLoop = " (itoa loopntt) "\t\terrn = " (itoa errntt) "\t\terrm = " (itoa errmtt)))
          (progn
            (prompt (strcat "\nSearch finished - correct solution not found...\nGetting best found solution from elapsed time...\t\tLoop = " (itoa loopnt) "\t\terrn= " (itoa errnt) "\t\terrm = " (itoa errmt)))
            (repeat loopnt
              (setq pll (append (cdr pll) (list (car pll))))
            )
            (setq fff t)
            (start pll errnt errmt)
          )
        )
        ;(_clos)
      )
    )
    (princ)
  )

  (defun rlw ( LW / E X1 X2 X3 X4 X5 X6 )
    ;; by ElpanovEvgeniy
    ;; reverse lwpolyline
    (if (= (cdr (assoc 0 (setq e (entget lw)))) "LWPOLYLINE")
      (progn (foreach a1 e
               (cond ((= (car a1) 10) (setq x2 (cons a1 x2)))
                     ((= (car a1) 40) (setq x4 (cons (cons 41 (cdr a1)) x4)))
                     ((= (car a1) 41) (setq x3 (cons (cons 40 (cdr a1)) x3)))
                     ((= (car a1) 42) (setq x5 (cons (cons 42 (- (cdr a1))) x5)))
                     ((= (car a1) 210) (setq x6 (cons a1 x6)))
                     (t (setq x1 (cons a1 x1)))
               )
             )
             (entmod (append (reverse x1)
                             (append (apply (function append)
                                            (apply (function mapcar)
                                                   (cons 'list
                                                         (list x2
                                                               (cdr (reverse (cons (car x3) (reverse x3))))
                                                               (cdr (reverse (cons (car x4) (reverse x4))))
                                                               (cdr (reverse (cons (car x5) (reverse x5))))
                                                         )
                                                   )
                                            )
                                     )
                                     x6
                             )
                     )
             )
             (entupd lw)
      )
    )
  )

  (defun col ( d / ang darkness )

    ;;; d^2=1^2+1^2-2*1*1*cos(a)
    ;;; d^2=2*(1-cos(a))
    ;;; cos(a)=1-d^2/2
    ;;; a=acos(1-d^2/2)
    (defun ang ( d )
      (acos (- 1.0 (/ (expt d 2.0) 2.0)))
    )

    (defun acos ( x )
      (if (<= -1.0 x 1.0)
        (cond
          ( (equal x 1.0)
            0.0
          )
          ( (equal x 0.0)
            (* 0.5 pi)
          )
          ( (equal x -1.0)
            pi
          )
          ( t
            (if (minusp (atan (sqrt (- 1.0 (* x x))) x))
              (+ (atan (sqrt (- 1.0 (* x x))) x) pi)
              (atan (sqrt (- 1.0 (* x x))) x)
            )
          )
        )
      )
    )

    (setq ang (ang d))
    (setq darkness (/ ang pi))
    (fix (- 255 (* 255 darkness))) ;;; r=g=b=(fix (- 255 (* 255 darkness)))
  )

  (defun unit (v / d)
    (if (not (equal (setq d (distance '(0.0 0.0 0.0) v)) 0.0 1e-8))
      (mapcar '(lambda (x) (/ x d)) v)
    )
  )

  (defun mid (p1 p2)
    (mapcar '(lambda (a b) (/ (+ a b) 2.0)) p1 p2)
  )

  (defun _ilpp (p1 p2 t1 t2 t3 / v^v unit _ilp nor o)

    (defun unit (v / d)
      (if (not (equal (setq d (distance '(0.0 0.0 0.0) v)) 0.0 1e-8))
        (mapcar '(lambda (x) (/ x d)) v)
      )
    )

    (defun v^v (u v)
      (list
        (- (* (cadr u) (caddr v)) (* (cadr v) (caddr u)))
        (- (* (car v) (caddr u)) (* (car u) (caddr v)))
        (- (* (car u) (cadr v)) (* (car v) (cadr u)))
      )
    )

    (defun _ilp (p1 p2 o nor / p1p p2p op tp pp p)
      (if (not (equal (v^v nor (unit (mapcar '- p2 p1))) '(0.0 0.0 0.0) 1e-7))
        (progn
          (setq p1p (trans p1 0 (v^v nor (unit (mapcar '- p2 p1))))
                p2p (trans p2 0 (v^v nor (unit (mapcar '- p2 p1))))
                op (trans o 0 (v^v nor (unit (mapcar '- p2 p1))))
                op (list (car op) (cadr op) (caddr p1p))
                tp (polar op (+ (* 0.5 pi) (angle '(0.0 0.0 0.0) (trans nor 0 (v^v nor (unit (mapcar '- p2 p1)))))) 1.0)
          )
          (if (inters p1p p2p op tp nil)
            (progn
              (setq p (trans (inters p1p p2p op tp nil) (v^v nor (unit (mapcar '- p2 p1))) 0))
              p
            )
            nil
          )
        )
        (progn
          (setq pp (list (car (trans p1 0 nor)) (cadr (trans p1 0 nor)) (caddr (trans o 0 nor))))
          (setq p (trans pp nor 0))
          p
        )
      )
    )

    (setq nor (unit (v^v (mapcar '- t3 t1) (mapcar '- t2 t1))))
    (setq o t1)

    (if (_ilp p1 p2 o nor)
      (_ilp p1 p2 o nor)
      nil
    )
  )

  (defun make3dlw (lwp / vl vlu vlup z)
    (setq vl (mapcar 'cdr (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget lwp))))
    (setq vl (mapcar '(lambda (x) (trans x lwp 0)) vl))
    (setq vlu (mapcar '(lambda (x) (_ilpp x (mapcar '+ x '(0.0 0.0 1.0)) (trans '(0.0 0.0 0.0) 1 0) (trans '(1.0 0.0 0.0) 1 0) (trans '(0.0 1.0 0.0) 1 0))) vl))
    (setq vlup (mapcar '(lambda (x) (trans x 0 (trans '(0.0 0.0 1.0) 1 0 t))) vlu))
    (setq z (- (caddr (trans '(0.0 0.0 0.0) 0 1))))
    (entmake
      (append
        (list
          '(0 . "LWPOLYLINE")
          '(100 . "AcDbEntity")
          '(100 . "AcDbPolyline")
          (cons 90 (length vl))
          '(70 . 1)
          (cons 38 z)
        )
        (mapcar '(lambda (x) (list 10 (car x) (cadr x))) vlup)
        (list (cons 210 (trans '(0.0 0.0 1.0) 1 0 t)))
      )
    )
    (setq vl (mapcar 'cdr (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget (entlast)))))
    (setq vl (mapcar '(lambda (x) (trans x (entlast) 0)) vl))
    (if (vl-every '(lambda (x) (equal (caddr (trans x 0 1)) 0.0 1e-6)) vl)
      (entlast)
      (progn
        (entdel (entlast))
        (setq vlup (mapcar '(lambda (x) (trans x 0 1)) vlu))
        (vl-cmdf "_.pline")
        (foreach p vlup
          (vl-cmdf "_non" p)
        )
        (vl-cmdf "_c")
        (entlast)
      )
    )
  )

  (defun unique (lst / a ll)
    (while (setq a (car lst))
      (if (vl-some '(lambda ( x ) (equal x a 1e-6)) (cdr lst))
        (setq ll (cons a ll) lst (vl-remove-if '(lambda (x) (equal x a 1e-6)) (cdr lst)))
        (setq ll (cons a ll) lst (cdr lst))
      )
    )
    (reverse ll)
  )

  (defun 2droof3d (/ slope->ang ListClockwise-p acDoc cmde pea ch ent tmp tot big poly reg vl ml ss lst el s)

    (vl-load-com)

    (or acDoc (setq acDoc (vla-get-activedocument (vlax-get-acad-object))))
    (setq ms (vlax-get acDoc (if (= 1 (getvar 'cvport)) 'paperspace 'modelspace)))
    (vla-startundomark acDoc)

    (defun slope->ang (sl / v1 v2 *ang)
      (setq v1 (list 0.0 0.0))
      (setq v2 (list 1.0 (/ sl 100.0)))
      (setq *ang (angle v1 v2))
      *ang
    )

    (defun ListClockwise-p (lst / z vlst)
      (vl-catch-all-apply 'minusp
        (list
          (if
            (not
              (equal 0.0
                (setq z
                  (apply '+
                    (mapcar
                      (function
                        (lambda (u v)
                          (- (* (car u) (cadr v)) (* (car v) (cadr u)))
                        )
                      )
                      (setq vlst
                        (mapcar
                          (function
                            (lambda (a b) (mapcar '- b a))
                          )
                          (mapcar (function (lambda (x) (car lst))) lst)
                          (cdr (reverse (cons (car lst) (reverse lst))))
                        )
                      )
                      (cdr (reverse (cons (car vlst) (reverse vlst))))
                    )
                  )
                )
                1e-6
              )
            )
            z
            (progn
              (prompt "\n\nChecked vectors are colinear - unable to determine clockwise-p of list")
              nil
            )
          )
        )
      )
    )

;-----------------------------------------------------------------------------------------------------------------------------------

    (if (= 0 (getvar 'worlducs))
      (exe (list "_.ucs" "_w"))
    )

    (or slope (setq slope 50))
    (or *ang* (setq *ang* 45))
    (setq tot 0.0)
    (setq cmde (getvar 'cmdecho))
    (setvar 'cmdecho 0)
    (setq pea (getvar 'peditaccept))
    (setvar 'peditaccept 1)
    (setq ape (getvar 'aperture))
    (setvar 'aperture 10)
    (setq osm (getvar 'osmode))
    (setvar 'osmode 0)

    (initget 1 "Slope Angle")
    (setq ch (getkword "\nInput value [Angle/Slope] : "))
    (if (eq ch "Slope")
      (progn
        (initget 6)
        (setq slope
          (cond
            ((getreal (strcat "\nSlope (%)" (if slope (strcat " <" (rtos slope 2 1) ">: ") ": "))))
            (slope)
          )
        )
      )
      (progn
        (initget 6)
        (setq *ang*
          (cond
            ((getreal (strcat "\nAngle in decimal degrees " (if *ang* (strcat " <" (rtos *ang* 2 1) ">: ") ": "))))
            ((float *ang*))
          )
        )
      )
    )

    (if (eq ch "Slope")
      (setq *ang* (cvunit (slope->ang slope) "radian" "degree"))
      (setq slope (* (/ (sin (* (/ *ang* 180.0) pi)) (cos (* (/ *ang* 180.0) pi))) 100.0))
    )

    (prompt "\nPick contour LWPOLYLINE")
    (setq poly (ssget "_+.:E:S:L" '((0 . "LWPOLYLINE") (-4 . "&") (70 . 1))))
    (setq poly (ssname poly 0))

    (setq vl (mapcar 'cdr (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget poly))))
    (setq vl (mapcar '(lambda (x) (trans x poly 0)) vl))
    (if (not (equal (car vl) (last vl) 1e-8)) (setq vl (reverse (cons (car vl) (reverse vl)))))
    (vlax-invoke (vlax-ename->vla-object poly) 'offset -1e-3)
    (if (> (vlax-curve-getarea (entlast)) (vlax-curve-getarea poly))     ;_force pointset CCW
      (setq vl (reverse vl))
    )
    (if (and (not (eq poly (entlast))) (= (cdr (assoc 0 (entget (entlast)))) "LWPOLYLINE"))
      (entdel (entlast))
      (if (eq poly (entlast))
        (progn
          (entdel (entlast))
          (entdel (entlast))
          (entdel poly)
        )
      )
    )
    ;;; (if (ListClockwise-p vl) (setq vl (reverse vl)))
    (setq ml (mapcar '(lambda (a b) (mid a b)) vl (append (cdr vl) (list (car vl)))))

    (vl-cmdf "_.explode" poly)
    (while (< 0 (getvar 'cmdactive)) (vl-cmdf ""))

    (prompt "\nSelect 2D roof solution LINE enitites with their contour")
    (while (not ss)
      (if
        (setq ss (ssget '((0 . "LINE"))))
        (progn
          (repeat (setq i (sslength ss))
            (setq lst (cons (vlax-ename->vla-object (ssname ss (setq i (1- i)))) lst))
          )
          (setq reg (vlax-invoke ms 'addregion lst))
        )
        (princ "\nEmpty selection...Try again...")
      )
    )

    (foreach r reg
      (setq ent (entlast))
      (vl-cmdf "_.pedit" "_m")
      (apply 'vl-cmdf (mapcar 'vlax-vla-object->ename (vlax-invoke r 'explode)))
      (vl-cmdf "" "_j" "" "")
      (if
        (and
          (not (eq ent (setq ent (entlast))))
          (= "LWPOLYLINE" (cdr (assoc 0 (entget ent))))
        )
        (progn
          (setq tmp (vlax-curve-getarea ent)
                tot (+ tot tmp)
          )
          (if (< (car big) tmp)
            (setq big (list tmp ent))
          )
        )
      )
      (vla-delete r)
    )
    (if (equal (car big) (/ tot 2.0) 1e-3)  ;; Gian Paolo Cattaneo
      (entdel (cadr big))
    )

    (setq ss (ssadd))

    (mapcar
      '(lambda (a b c / p1 p2 zl lw 3dlw)
         (progn
           (setq p1 (osnap (mapcar '+ a (mapcar '* '(0.1 0.1 0.1) (mapcar '- b a))) "_nea")
                 p2 (osnap (mapcar '+ a (mapcar '* '(0.9 0.9 0.9) (mapcar '- b a))) "_nea")
                 zl (acet-geom-list-extents (list a b))
           )
           (exe (list "_.zoom" "_w" (car zl) (cadr zl)))
           (if (eq (sslength (ssget "_CP" (list (polar p1 (+ (angle p1 p2) (* 0.5 pi)) 1e-3) (polar p1 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* 0.5 pi)) 1e-3)) '((0 . "LWPOLYLINE,LINE")))) 2)
             (progn
               (exe (list "_.ucs" "_3p" "_non" a "_non" b ""))
               (exe (list "_.ucs" "_3p" "_non" '(0.0 0.0 0.0) "_non" '(1.0 0.0 0.0) "_non" (list 0.0 (cos (* (/ *ang* 180.0) pi)) (sin (* (/ *ang* 180.0) pi)))))
               (if (and (setq s (ssget "_C" (osnap (trans c 0 1) "_mid") (osnap (trans c 0 1) "_nea") '((0 . "LWPOLYLINE"))))
                        (setq lw (ssname s 0))
                   )
                 (progn
                   (setq 3dlw (make3dlw lw))
                   (setq el (entlast))
                   (exe (list "_.loft" lw 3dlw "" ""))
                   (if (not (eq el (entlast)))
                     (progn
                       (ssadd (entlast) ss)
                       (if (entget lw) (entdel lw))
                       (if (entget 3dlw) (entdel 3dlw))
                       (repeat 2
                         (exe (list "_.ucs" "_p"))
                       )
                     )
                     (progn
                       (exe (list "_.extrude" lw "" 1e+6 ""))
                       (setq el (entlast))
                       (exe (list "_.slice" el "" "_ob" 3dlw "_non" '(0.0 0.0 -1.0)))
                       (ssadd el ss)
                       (if (entget lw) (entdel lw))
                       (if (entget 3dlw) (entdel 3dlw))
                       (repeat 2
                         (exe (list "_.ucs" "_p"))
                       )
                     )
                   )
                 )
                 (repeat 2
                   (exe (list "_.ucs" "_p"))
                 )
               )
             )
           )
           (exe (list "_.zoom" "_p"))
         )
       )
       vl (append (cdr vl) (list (car vl))) ml
    )

    (foreach obj lst
      (if (not (vlax-erased-p obj))
        (vla-delete obj)
      )
    )

    (exe (list "_.union" ss ""))
    (if (= (cdr (assoc 0 (entget (entlast)))) "3DSOLID")
      (setq el (entlast))
    )
    (exe (list "_.ucs" "_p"))
    el
  )

  (defun 2droof3d-island (poly / slope->ang ch lwn)

    (or acDoc (setq acDoc (vla-get-activedocument (vlax-get-acad-object))))

    (defun slope->ang (sl / v1 v2 *ang)
      (setq v1 (list 0.0 0.0))
      (setq v2 (list 1.0 (/ sl 100.0)))
      (setq *ang (angle v1 v2))
      *ang
    )

;-----------------------------------------------------------------------------------------------------------------------------------

    (or slope (setq slope 50))
    (or *ang* (setq *ang* 45))

    (initget 1 "Slope Angle")
    (setq ch (getkword "\nInput value [Angle/Slope] : "))
    (if (eq ch "Slope")
      (progn
        (initget 6)
        (setq slope
          (cond
            ((getreal (strcat "\nSlope (%)" (if slope (strcat " <" (rtos slope 2 1) ">: ") ": "))))
            (slope)
          )
        )
      )
      (progn
        (initget 6)
        (setq *ang*
          (cond
            ((getreal (strcat "\nAngle in decimal degrees " (if *ang* (strcat " <" (rtos *ang* 2 1) ">: ") ": "))))
            ((float *ang*))
          )
        )
      )
    )

    (if (eq ch "Slope")
      (setq *ang* (cvunit (slope->ang slope) "radian" "degree"))
      (setq slope (* (/ (sin (* (/ *ang* 180.0) pi)) (cos (* (/ *ang* 180.0) pi))) 100.0))
    )

    (exe (list "_.zoom" "_e"))
    (or *d* (setq *d* (/ (distance (getvar 'extmin) (getvar 'extmax)) 2.0)))
    (vl-cmdf "_.extrude" "_mo" "_so" poly "" "_t" (- (- 90.0 *ang*)) *d*)
    (while (< 0 (getvar 'cmdactive))
      (vl-cmdf "")
    )
    (exe (list "_.zoom" "_p"))
    (entlast)
  )

  (defun hatchprocess (hop ent tr)
    (cond
      ( (= hop "1")
        (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" ent)
        (while (< 0 (getvar 'cmdactive))
          (vl-cmdf "")
        )
        (vla-put-patternscale (vlax-ename->vla-object (entlast)) gap)
        (vla-put-patternspace (vlax-ename->vla-object (entlast)) gap)
        (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
        (vla-setrgb cc c c c)
        (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
      )
      ( (= hop "2")
        (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" ent)
        (while (< 0 (getvar 'cmdactive))
          (vl-cmdf "")
        )
        (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
        (vla-setrgb cc c c c)
        (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
        (vla-put-entitytransparency (vlax-ename->vla-object (entlast)) (rtos tr 2 8))
      )
      ( t
        (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" ent)
        (while (< 0 (getvar 'cmdactive))
          (vl-cmdf "")
        )
        (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
        (vla-setrgb cc c c c)
        (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
        (vla-put-entitytransparency (vlax-ename->vla-object (entlast)) (rtos tr 2 8))
        (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" ent)
        (while (< 0 (getvar 'cmdactive))
          (vl-cmdf "")
        )
        (vla-put-patternscale (vlax-ename->vla-object (entlast)) gap)
        (vla-put-patternspace (vlax-ename->vla-object (entlast)) gap)
      )
    )
  )

  (or acDoc (setq acDoc (vla-get-activedocument (vlax-get-acad-object))))

  (setq cmde (getvar 'cmdecho))
  (setvar 'cmdecho 0)
  (setq pea (getvar 'peditaccept))
  (setvar 'peditaccept 1)
  (setq ape (getvar 'aperture))
  (setvar 'aperture 10)
  (setq osm (getvar 'osmode))
  (setvar 'osmode 0)
  (if (= 0 (getvar 'worlducs))
    (exe (list "_.ucs" "_w"))
  )
  (while (= 8 (logand 8 (getvar 'undoctl)))
    (exe (list "_.undo" "_e"))
  )
  (exe (list "_.undo" "_be"))
  (prompt "\nSelect all LWPOLYLINES - both inner and outer one on unlocked layer(s)...")
  (setq ss (ssget "_:L" '((0 . "LWPOLYLINE") (-4 . "&") (70 . 1))))
  (setq lws (_vl-sort (vl-remove-if 'listp (mapcar 'cadr (ssnamex ss))) '(lambda (a b) (> (vlax-curve-getarea a) (vlax-curve-getarea b)))))
  (vlax-invoke (vlax-ename->vla-object (car lws)) 'offset -1e-3)
  (if (< (vlax-curve-getarea (entlast)) (vlax-curve-getarea (car lws)))
    (rlw (car lws))
  )
  (entdel (entlast))
  (foreach lw (cdr lws)
    (vlax-invoke (vlax-ename->vla-object lw) 'offset -1e-3)
    (if (> (vlax-curve-getarea (entlast)) (vlax-curve-getarea lw))
      (rlw lw)
    )
    (entdel (entlast))
  )
  (2droof-final)
  (setq sol1 (2droof3d))
  (setq ent nil)
  (while (or (setq ent (car (entsel "\nPick a closed island polygonal LWPOLYLINE... - ENTER TO FINISH or just ENTER if no islands..."))) (acet-sys-lmouse-down))
    (if ent
      (setq sol2l (cons (2droof3d-island ent) sol2l))
    )
  )
  (setq ss (ssadd))
  (while sol2l
    (ssadd (car sol2l) ss)
    (setq sol2l (cdr sol2l))
  )
  (if (and ss (/= (sslength ss) 0))
    (exe (list "_.subtract" sol1 "" ss ""))
  )
  (if (= (cdr (assoc 0 (entget (entlast)))) "3DSOLID")
    (setq sol1 (entlast))
  )

  (initget "1 2 3")
  (setq op (getkword "\nChoose an option [1 3dsolid/2 2dhatch/3 3dsolid-3dhatch] <2 2dhatch> : "))
  (if (null op)
    (setq op "2")
  )
  (if (/= op "1")
    (progn
      (initget 1)
      (setq v (getpoint "\nPick or specify light source point to determine light vector of parallel rays - point must differ from target point 0,0,0 : "))
      (while (equal v (list 0.0 0.0 0.0) 1e-6)
        (prompt "\nInvalid specification - source vector point must differ from target point 0,0,0...")
        (initget 1)
        (setq v (getpoint "\nPick or specify light source point to determine light vector of parallel rays - point must differ from target point 0,0,0 : "))
      )
      (initget "1 2 3")
      (setq hop (getkword "\nDo you want linear or solid hatch [1 linear/ 2 solid /3 both] <1 linear> : "))
      (if (null hop)
        (setq hop "1")
      )
      (if (/= hop "2")
        (progn
          (initget 7)
          (setq gap (getdist "\nPick or specify gap between vertical hatching lines : "))
        )
      )
      (if (/= hop "1")
        (progn
          (setq tr 200.0)
          (while (> tr 100.0)
            (initget 6)
            (setq tr (getreal "\nSpecify amount of transparency of solid hatches [0-100]% <0> : "))
            (if (null tr)
              (setq tr 0.0)
            )
          )
        )
      )
      (setq v (unit v))
      (setq el (entlast) lst nil)
      (exe (list "_.xedges" sol1 ""))
      (exe (list "_.copybase" "_non" (list 0.0 0.0 0.0) sol1 ""))
      (if (/= op "1")
        (progn
          (entdel sol1)
          (while (setq el (entnext el))
            (cond
              ( (= "LINE" (cdr (assoc 0 (entget el))))
                (entmod (subst (cons 10 (append (mapcar '+ '(0 0) (cdr (assoc 10 (entget el)))) (list 0.0))) (assoc 10 (entget el)) (entget el)))
                (entmod (subst (cons 11 (append (mapcar '+ '(0 0) (cdr (assoc 11 (entget el)))) (list 0.0))) (assoc 11 (entget el)) (entget el)))
                (if (or (not (vl-member-if '(lambda (x) (equal x (list (cdr (assoc 10 (entget el))) (cdr (assoc 11 (entget el)))) 1e-6)) lil)) (not (vl-member-if '(lambda (x) (equal x (list (cdr (assoc 11 (entget el))) (cdr (assoc 10 (entget el)))) 1e-6)) lil)))
                  (setq lst (cons (vlax-ename->vla-object el) lst) lil (cons (list (cdr (assoc 10 (entget el))) (cdr (assoc 11 (entget el)))) lil))
                  (setq ell (cons el ell))
                )
              )
              ( (= "SPLINE" (cdr (assoc 0 (entget el))))
                (setq ell (cons el ell))
                (cond
                  ( (> (length (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget el))) 1)
                    (setq lst (cons (vlax-ename->vla-object (entmakex (list (cons 0 "LINE") (cons 10 (append (mapcar '+ '(0 0) (cdr (assoc 10 (entget el)))) (list 0.0))) (cons 11 (append (mapcar '+ '(0 0) (cdr (assoc 10 (reverse (entget el))))) (list 0.0)))))) lst) lil (cons (list (cdr (assoc 10 (entget (entlast)))) (cdr (assoc 11 (entget (entlast))))) lil))
                  )
                  ( (and (= (length (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget el))) 1) (< (vl-position (assoc 10 (entget el)) (entget el)) (vl-position (assoc 11 (entget el)) (entget el))))
                    (setq lst (cons (vlax-ename->vla-object (entmakex (list (cons 0 "LINE") (cons 10 (append (mapcar '+ '(0 0) (cdr (assoc 10 (entget el)))) (list 0.0))) (cons 11 (append (mapcar '+ '(0 0) (cdr (assoc 11 (reverse (entget el))))) (list 0.0)))))) lst) lil (cons (list (cdr (assoc 10 (entget (entlast)))) (cdr (assoc 11 (entget (entlast))))) lil))
                  )
                  ( (and (= (length (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget el))) 1) (> (vl-position (assoc 10 (entget el)) (entget el)) (vl-position (assoc 11 (entget el)) (entget el))))
                    (setq lst (cons (vlax-ename->vla-object (entmakex (list (cons 0 "LINE") (cons 10 (append (mapcar '+ '(0 0) (cdr (assoc 11 (entget el)))) (list 0.0))) (cons 11 (append (mapcar '+ '(0 0) (cdr (assoc 10 (reverse (entget el))))) (list 0.0)))))) lst) lil (cons (list (cdr (assoc 10 (entget (entlast)))) (cdr (assoc 11 (entget (entlast))))) lil))
                  )
                  ( (> (length (vl-remove-if '(lambda (x) (/= (car x) 11)) (entget el))) 1)
                    (setq lst (cons (vlax-ename->vla-object (entmakex (list (cons 0 "LINE") (cons 10 (append (mapcar '+ '(0 0) (cdr (assoc 11 (entget el)))) (list 0.0))) (cons 11 (append (mapcar '+ '(0 0) (cdr (assoc 11 (reverse (entget el))))) (list 0.0)))))) lst) lil (cons (list (cdr (assoc 10 (entget (entlast)))) (cdr (assoc 11 (entget (entlast))))) lil))
                  )
                )
              )
            )
          )
          (foreach el ell
            (if (not (vlax-erased-p el))
              (entdel el)
            )
          )
          (setq regs (mapcar 'vlax-vla-object->ename (vl-catch-all-apply 'vlax-invoke (list ms 'addregion lst))))
          (setq sel (ssget "_A" '((0 . "LINE"))))
          (if (and sel (= (type sel) 'pickset) (/= 0 (sslength sel)))
            (exe (list "_.erase" sel ""))
          )
          (prompt "\nSelect island regions - ENTER for none...")
          (setq sel (ssget "_:L" '((0 . "REGION"))))
          (if sel
            (progn
              (setq regs (vl-remove-if '(lambda (x)
                                               (vl-some '(lambda (y) (eq x y)) (setq islrgs (vl-remove-if 'listp (mapcar 'cadr (ssnamex sel)))))
                                        )
                                        regs
                         )
              )
              (foreach r islrgs
                (vl-cmdf "_.explode" r)
                (while (< 0 (getvar 'cmdactive))
                  (vl-cmdf "")
                )
                
                (vl-cmdf "_.pedit" "_m" (ssget "_P") "" "_j")
                (while (< 0 (getvar 'cmdactive))
                  (vl-cmdf "")
                )
                
                (setq isl (cons (entlast) isl))
              )
            )
          )
          (prompt "\nSelect main biggest region...")
          (setq mainreg (ssname (ssget "_+.:E:S:L" '((0 . "REGION"))) 0))
          (vl-cmdf "_.explode" mainreg)
          (while (< 0 (getvar 'cmdactive))
            (vl-cmdf "")
          )
          
          (vl-cmdf "_.pedit" "_m" (ssget "_P") "" "_j")
          (while (< 0 (getvar 'cmdactive))
            (vl-cmdf "")
          )
          
          (setq main (entlast))
          (foreach r regs
            (vl-cmdf "_.explode" r)
            (while (< 0 (getvar 'cmdactive))
              (vl-cmdf "")
            )
            
            (vl-cmdf "_.pedit" "_m" (ssget "_P") "" "_j")
            (while (< 0 (getvar 'cmdactive))
              (vl-cmdf "")
            )
            
          )
          (foreach lw isl
            (vlax-invoke (vlax-ename->vla-object lw) 'offset -1e-3)
            (if (< (vlax-curve-getarea (entlast)) (vlax-curve-getarea lw))
              (setq vll (cons (reverse (mapcar 'cdr (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget lw)))) vll))
              (setq vll (cons (mapcar 'cdr (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget lw))) vll))
            )
            (entdel (entlast))
          )
          (vlax-invoke (vlax-ename->vla-object main) 'offset -1e-3)
          (if (< (vlax-curve-getarea (entlast)) (vlax-curve-getarea main))
            (setq vll (cons (mapcar 'cdr (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget main))) vll))
            (setq vll (cons (reverse (mapcar 'cdr (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget main)))) vll))
          )
          (entdel (entlast))
          (foreach vl vll
            (mapcar
             '(lambda (a b / p1 p2 zl lw 3dlw)
                (exe (list "_.ucs" "_w"))
                (exe (list "_.zoom" "_e"))
                (setq p1 (osnap (mapcar '+ a (mapcar '* '(0.01 0.01 0.01) (mapcar '- b a))) "_nea")
                      p2 (osnap (mapcar '+ a (mapcar '* '(0.02 0.02 0.02) (mapcar '- b a))) "_nea")
                      zl (acet-geom-list-extents (list a b))
                )
                (exe (list "_.zoom" "_w" (car zl) (cadr zl)))
                (setq sel (ssget "_CP" (list (polar p1 (+ (angle p1 p2) (* 0.5 pi)) 1e-3) (polar p1 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* 0.5 pi)) 1e-3)) '((0 . "LWPOLYLINE"))))
                (if (and sel (= (type sel) 'pickset) (/= (sslength sel) 0) (not (ssget "_CP" (list (polar p1 (+ (angle p1 p2) (* 0.5 pi)) 1e-3) (polar p1 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* 0.5 pi)) 1e-3)) '((0 . "HATCH")))))
                  (progn
                    (exe (list "_.ucs" "_3p" "_non" a "_non" b ""))
                    (exe (list "_.ucs" "_3p" "_non" '(0.0 0.0 0.0) "_non" '(1.0 0.0 0.0) "_non" (list 0.0 (cos (* (/ *ang* 180.0) pi)) (sin (* (/ *ang* 180.0) pi)))))
                    (if (ssmemb main sel)
                      (ssdel main sel)
                    )
                    (foreach is isl
                      (if (ssmemb is sel)
                        (ssdel is sel)
                      )
                    )
                    (if (> (sslength sel) 0)
                      (setq lw (car (_vl-sort (vl-remove-if 'listp (mapcar 'cadr (ssnamex sel))) '(lambda (a b) (< (vlax-curve-getarea a) (vlax-curve-getarea b))))))
                    )
                    (if (= op "2")
                      (if lw
                        (progn
                          (setq 3dlw (vl-catch-all-apply 'make3dlw (list lw)))
                          (setq el (entlast))
                          (if (not (vl-catch-all-error-p 3dlw))
                            (exe (list "_.loft" 3dlw lw "" ""))
                          )
                          (if (not (eq el (entlast)))
                            (progn
                              (exe (list "_.undo" 1))
                              (if (not (vlax-erased-p 3dlw))
                                (entdel 3dlw)
                              )
                              (setq c (col (distance v (trans '(0.0 0.0 1.0) 1 0 t))))
                              (exe (list "_.ucs" "_p"))
                              (hatchprocess hop lw tr)
                            )
                            (progn
                              (if (not (vlax-erased-p 3dlw))
                                (entdel 3dlw)
                              )
                              (setq c (col (distance v (trans '(0.0 0.0 1.0) 1 0 t))))
                              (exe (list "_.ucs" "_p"))
                              (hatchprocess hop lw tr)
                            )
                          )
                        )
                      )
                    )
                    (if (= op "3")
                      (if lw
                        (progn
                          (setq 3dlw (vl-catch-all-apply 'make3dlw (list lw)))
                          (setq el (entlast))
                          (if (not (vl-catch-all-error-p 3dlw))
                            (exe (list "_.loft" 3dlw lw "" ""))
                          )
                          (if (not (eq el (entlast)))
                            (progn
                              (exe (list "_.undo" 1))
                              (if (not (vlax-erased-p lw))
                                (entdel lw)
                              )
                              (setq c (col (distance v (trans '(0.0 0.0 1.0) 1 0 t))))
                              (hatchprocess hop 3dlw tr)
                            )
                            (progn
                              (if (not (vlax-erased-p lw))
                                (entdel lw)
                              )
                              (setq c (col (distance v (trans '(0.0 0.0 1.0) 1 0 t))))
                              (hatchprocess hop 3dlw tr)
                            )
                          )
                        )
                      )
                    )
                  )
                )
                (exe (list "_.zoom" "_p"))
              )
              vl (append (cdr vl) (list (car vl)))
            )
          )
          (foreach obj lst
            (if (not (vlax-erased-p obj))
              (vla-delete obj)
            )
          )
        )
      )
    )
  )
  (while (= 0 (getvar 'worlducs))
    (exe (list "_.ucs" "_p"))
  )
  (if (= op "3")
    (exe (list "_.pasteclip" "_non" (list 0.0 0.0 0.0)))
  )

  (vla-regen acDoc acactiveviewport)

  (exe (list "_.undo" "_e"))
  (*error* nil)
)